/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RandomHtmlGenerator.java,v 1.3 2005/10/21 11:01:07 rampil Exp $
 */
package org.logical_paradox.httpd.html.random;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.lang.Random;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.httpd.ClientRequest;
import org.logical_paradox.httpd.HttpdProperties;
import org.logical_paradox.httpd.ResponseHeader;
import org.logical_paradox.httpd.ServerResponse;
import org.logical_paradox.httpd.exception.HttpException;
import org.logical_paradox.httpd.html.HtmlGenerator;

/**
 * KHTML𐶐ĕԂ^CvHTMLWFl[^
 * y[Wɂ́AKȐʂ̃Nݒ肳Ă
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RandomHtmlGenerator extends HtmlGenerator {
	/** {bgt@C̃t@C */
	public static final String ROBOTS_TXT = "robots.txt";
	/** ^Õev[g */
	public static final String[] TAG_TEMPLATES = {
			"<FONT COLOR=RED>__d__</FONT>", "<b>__d__</b>", "<span style=\"font-size: 10px\">__d__</span>",
			"<br>","<a name=test>__d__</a><br>","<p>"
		};
	/** gbvhC */
	public static final String[] DOMAIN_SUFFIXES = {
			"com", "net", "co.jp", "co.kr", "ne.jp", "ne.kr", "cn", "com.tw", "com.uk", "com.hk",
			"org", "jp", "biz", "tv", "info", "gov", "go.jp"
		};

	/** K[ */
	private static final Log log = LogFactory.getLog(RandomHtmlGenerator.class);

	/** _g[N */
	private List tokens;
	/** _ڑ */
	private List conjuctions;
	/** WFl[^ */
	private Random r = new Random(Random.PLUS_OR_ZERO);

	/** _Pꎫt@C̃vpeBL[ */
	public static final String KEY_RANDOM_TOKEN_DICTIONARY = "random.token.dic";
	/** _ڑt@C̃vpeBL[ */
	public static final String KEY_RANDOM_CONJUCTION_DICTIONARY = "random.conjuction.dic";

	/**
	 * HTMLy[WԂ
	 * @param request NCAg̃NGXg
	 * @return ꂽHTML
	 * @throws HttpException hLgɔO(404403Ȃ)
	 */
	public ServerResponse generateHtml(ClientRequest request) throws HttpException {
		if(tokens == null || conjuctions == null) {
			loadDictionary();
		}
		String contentType = null;
		String content = "";
		int httpStatusCode = 200;

		if(r.nextInt() % 20 == 0) {
			// 1/20̊mNot FoundԂ
			httpStatusCode = 404;
		} else if(r.nextInt() % 20 == 1) {
			// 1/20̊mForbiddenԂ
			httpStatusCode = 403;
		} else if(r.nextInt() % 30 == 2) {
			// 1/30̊mInternal Server ErrorԂ
			httpStatusCode = 500;
		}

		if(httpStatusCode != 200) {
			// OKȊÕXe[^X̏ꍇCG[y[WƂ邽߂ɗOX[
			throw new HttpException(httpStatusCode);
		}

		if(request.getQuery().endsWith(ROBOTS_TXT)) {
			// robots.txtvꂽꍇCKȂ̂𐶐ĕԂ(Ȃ̏ꍇ)
			// robots.txttext/plainł
			contentType = "text/plain";
		} else {
			// KHTML𐶐
			content = generateHtmlDocument(request);
		}

		// X|X̐
		ServerResponse response = new ServerResponse(new ResponseHeader(), content);

		if(r.nextInt() % 10 == 0) {
			// 1/10̊mŁAMoved TemporarilyԂ
			response.setHttpStatusCode(302);
			String forwardTo = generateURL(request);
			response.put("Location", forwardTo);
			log.info("====> " + forwardTo);
			return response;
		}

		if(contentType != null) {
			// 炩̃X|Xwb_w肳ĂꍇC̗p
			response.put(ResponseHeader.H_CONTENT_TYPE, contentType);
		}
		return response;
	}
	/**
	 * zXg𐶐ĕԂD
	 * @param request NGXgp[^
	 * @return ꂽzXg
	 */
	public String generateHost(ClientRequest request) {
		String hostname = null;

		if("true".equals(HttpdProperties.getProperty(HttpdProperties.LINK_TO_ONLY_LOCALHOST).toLowerCase())) {
			// localhostɑ΂郊N̂ݐ
			hostname = request.getConfig().getHostName() + ":" + request.getConfig().getPort();
		} else {
			// KȃzXgƓKȃ|[gԍ𐶐
			hostname = StringUtils.randomTextRange(4, 15) + "." + selectTopDomain();
			if(r.nextInt() % 100 < 5) {
				// 5%炢̊mŁC8000Ԃ̃|[gԍǉ
				hostname += ":" + ((r.nextInt() % 100) + 8000);
			}
		}

		return hostname;
	}
	/**
	 * Kɐrobots.txtԂ
	 * @return ꂽrobots.txt(null: Ȃ)
	 */
	public String generateRobotsTxt() {
		return "";
	}
	/**
	 * HTML쐬
	 * e̓_ł
	 * @param request NCAg̃NGXg
	 * @return ꂽHTML
	 */
	public String generateHtmlDocument(ClientRequest request) {
		StringBuffer sb = new StringBuffer();

		// hLgprefixǉ
		sb.append("<HTML><HEAD><TITLE>" + getRandomWordCpx() + "</TITLE></HEAD><BODY>");

		int documentSize = (r.nextInt() % 8 +1) * 1000;
		while(sb.length() < documentSize) {
			if(r.nextInt() % 10 == 0) {
				// 1/10̊mŃN𐶐
				sb.append("<br><a href=" + generateURL(request) + ">" + getRandomWordCpx() + "</a><br>");
			} else {
				String randomSentence = getRandomSentence();
				if(r.nextInt() % 10 <= 3) {
					// 30%̊mŃ^O}
					String chosenTag = getRandomTag();
					sb.append(chosenTag.replaceAll("__d__", randomSentence) + "<br>\n");
				}
			}
		}

		// hLgpostfixǉ
		sb.append("</BODY></HTML>");

		return sb.toString();
	}
	/**
	 * KURL𐶐ĕԂ
	 * FQDNԂꍇ邵C΃pXƂĕԂꍇ
	 * @return ꂽKURL
	 */
	public String generateURL(ClientRequest request) {
		StringBuffer path = new StringBuffer();

		// ̊mŁAhCwȂ
		if(r.nextInt() % 10 < 2) {
			path.append("http://" + generateHost(request) + "/");
		} else {
			if(r.nextInt() % 2 == 0) {
				// 1/2̊mŉ炩̃pXw
				if(r.nextInt() % 10 >= 7) {
					path.append("./");				// 30%
				} else if(r.nextInt() % 10 == 0) {
					path.append("../../");			// 10%
				} else {
					path.append("../");
				}
			}
		}

		/*
		 * t@C̐
		 * KwłĂRSSƂĂ͊֌WȂ̂œKɃt@CԂ
		 */
		path.append(StringUtils.randomTextRange(4, 15) + ".html");

		return path.toString();
	}
	/**
	 * gbvhCID
	 * @return gbvhC
	 */
	public String selectTopDomain() {
		int index = r.nextInt() % DOMAIN_SUFFIXES.length;
		return DOMAIN_SUFFIXES[index];
	}
	/**
	 * ^Oev[gKȃ^Op^[IĕԂ
	 * @return Iꂽ^Op^[
	 */
	public String getRandomTag() {
		return TAG_TEMPLATES[r.nextInt() % TAG_TEMPLATES.length];
	}
	/**
	 * _ȖԂ
	 * @return Iꂽ
	 */
	public String getRandomWord() {
		return (String)tokens.get(r.nextInt() % tokens.size());
	}
	/**
	 * _ȐڑԂ
	 * @return Iꂽڑ
	 */
	public String getRandomConjuction() {
		return (String)conjuctions.get(r.nextInt() % conjuctions.size());
	}
	/**
	 * ̖Ȃ킹Ԃ
	 * @return Iꂽ
	 */
	public String getRandomWordCpx() {
		// ̌1`4
		int connections = r.nextInt() % 4 + 1;
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < connections; i++) {
			sb.append(getRandomWord());
		}

		return sb.toString();
	}
	/**
	 * ڑŌKȕ͂쐬ĕԂ
	 * @return ꂽ
	 */
	public String getRandomSentence() {
		// Ɛڑ̌6`40
		int connections = r.nextInt() % 35 + 6;
		StringBuffer sb = new StringBuffer();

		for(int i = 0; i < connections; i++) {
			sb.append(getRandomWordCpx());				// 
			sb.append(getRandomConjuction());			// ڑ
		}

		return sb.toString();
	}
	/**
	 * PƐڑ̎[h
	 */
	protected synchronized void loadDictionary() {
		try {
			// Pt@C[h
			ArrayList tokenList = new ArrayList();
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(HttpdProperties.getProperty(KEY_RANDOM_TOKEN_DICTIONARY))));
			String line = null;
			while((line = br.readLine()) != null) {
				tokenList.add(line.trim());
			}
			br.close();
			// immutableȎƂēo^
			tokens = Collections.unmodifiableList(tokenList);

			// ڑt@C[h
			ArrayList conjuctionList = new ArrayList();
			br = new BufferedReader(new InputStreamReader(new FileInputStream(HttpdProperties.getProperty(KEY_RANDOM_CONJUCTION_DICTIONARY))));
			line = null;
			while((line = br.readLine()) != null) {
				conjuctionList.add(line.trim());
			}
			br.close();
			// immutableȐڑƂēo^
			conjuctions = Collections.unmodifiableList(conjuctionList);
		} catch (Exception e) {
			e.printStackTrace();
			// t@Cǂ߂ȂꍇC~̂悤Ȃ̂œKȎ쐬
			tokens = new ArrayList();
			conjuctions = new ArrayList();

			tokens.add("Pꎫ̃[hɎs");
			conjuctions.add("ڑ̃[hɎs");
		}
	}
}
