/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Shutdown.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

import org.logical_paradox.common.cli.Argument;
import org.logical_paradox.common.cli.ArgumentParser;

/**
 * httpT[o[Vbg_Ec[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Shutdown {
	/**
	 * C\bh
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		String remoteHost = Config.DEFAULT_HOSTNAME;
		int port = Config.DEFAULT_LISTENING_PORT;

		// ̉
		Argument[] options = ArgumentParser.parse(args);

		for(int i = 0; i < options.length; i++) {
			if("host".equals(options[i].getName())) {
				remoteHost = options[i].getValue();
			} else if("port".equals(options[i].getName())) {
				port = Integer.parseInt(options[i].getValue());
			}
		}

		// w肳ꂽT[o[(ȗ=localhost)ɑ΂exit\bh@
		try {
			Socket clientSocket = new Socket(remoteHost, port);
			PrintWriter pw = new PrintWriter(clientSocket.getOutputStream());
			// EXIT\bh𑗐M
			pw.println("EXIT / HTTP/1.0");
			pw.flush();
			// Ƒ҂(T[o[̂قsocketclosex)
			Thread.sleep(500);
			pw.close();
		} catch(IOException e) {
			// T[o[closêŖ
		}

		System.out.println("httpT[o[Vbg_E܂");
	}
}
