/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ResponseHeader.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.logical_paradox.httpd.html.ErrorCodeDictionary;

/**
 * X|Xwb_NX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ResponseHeader {
	/** ftHg̃T[o[vgRƃo[W */
	public static final String DEFAULT_SERVER_PROTOCOL = "HTTP/1.1";

	/** wb_L[: Content-Type */
	public static final String H_CONTENT_TYPE = "Content-Type";
	/** wb_L[: Connection */
	public static final String H_CONNECTION = "Connection";

	/** HTTP̃X|XR[h */
	private int responseCode = 200;

	/** X|Xwb_ */
	private ArrayList hvp = new ArrayList();

	/**
	 * RXgN^
	 */
	public ResponseHeader() {
		// ftHg̃Rec^Cvݒ肷
		hvp.add(new HeaderValuePair(H_CONTENT_TYPE, HttpdProperties.getProperty(HttpdProperties.DEFAULT_CONTENTTYPE)));
		hvp.add(new HeaderValuePair(H_CONNECTION, "close"));
	}
	/**
	 * RXgN^
	 * @param responseCode HTTP̃X|XR[h
 	 */
	public ResponseHeader(int rc) {
		// ftHgRXgN^̌ďo
		this();
		// X|XR[h̐ݒ
		responseCode = rc;
	}
	/**
	 * Rs[RXgN^
	 * @param rh Rs[̃X|Xwb_
	 */
	public ResponseHeader(ResponseHeader rh) {
		hvp = (ArrayList)rh.getHeaders().clone();
	}
	/**
	 * o^Ă郌X|Xwb_̃}bvԂ
	 * @return X|Xwb_̃}bv
	 */
	private ArrayList getHeaders() {
		return hvp;
	}
	/**
	 * wb_ǉ
	 * @param key wb_
	 * @param value wb_l
	 */
	public void put(String key, String value) {
		synchronized(hvp) {
			// wb_̏d邽߁CƂ肠폜Ăǉ
			remove(key);
			hvp.add(new HeaderValuePair(key, value));
		}
	}
	/**
	 * w肳ꂽwb_X|Xwb_̃Xg폜
	 * @param key wb_
	 */
	public void remove(String key) {
		synchronized(hvp) {
			HeaderValuePair p = new HeaderValuePair(key, "");
			if(hvp.contains(new HeaderValuePair(key, ""))) {
				hvp.remove(p);
			}
		}
	}
	/**
	 * X|XR[hԂ
	 * @return HTTPX|XR[h
	 */
	public int getResponseCode() {
		return responseCode;
	}
	/**
	 * X|XR[hݒ肷
	 * @param HTTPX|XR[h
	 */
	public void setResponseCode(int rc) {
		responseCode = rc;
	}
	/**
	 * HTTPXe[^XR[hƂĂ̕Ԃ
	 * @return HTTPXe[^XR[h(\)
	 */
	public String getHttpStatusCode() {
		return DEFAULT_SERVER_PROTOCOL + " " + getResponseCode() + " " + ErrorCodeDictionary.getMessage(getResponseCode());
	}
	/**
	 * wb_ƃL[̃yAɑ΂ăANZXCe[^Ԃ
	 * @return Ce[^
	 */
	public Iterator iteratorHeader() {
		return new HeaderValueIterator(getHeaders());
	}

	/**
	 * wb_ƒl̑gݍ킹荞ރCe[^
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	class HeaderValueIterator implements Iterator {
		/** wb_ƒl̃yAi[z(Ce[V̑Ώ) */
		private ArrayList baseArray = new ArrayList();
		/** Qƃ|Cg */
		private int pos = 0;

		/**
		 * RXgN^
		 * z̓eHeaderValuePairNX
		 * @param ar wb_l̔z
		 */
		private HeaderValueIterator(ArrayList ar) {
			synchronized(ar) {
				for(Iterator it = ar.iterator(); it.hasNext();) {
					HeaderValuePair hvp = (HeaderValuePair)it.next();
					baseArray.add(hvp.toString());
				}
			}
		}
		/**
		 * o[폜
		 * ̃\bh̓T|[gĂȂ
		 */
		public void remove() {
		}
		/**
		 * ̃o[擾ł邩ǂԂ
		 * @return true: / false:Ȃ
		 */
		public boolean hasNext() {
			return pos < baseArray.size();
		}
		/**
		 * ̃IuWFNgԂ
		 * @return ̒l
		 */
		public Object next() {
			if(hasNext() == false) {
				throw new NoSuchElementException();
			}
			return baseArray.get(pos++);
		}
	}
	/**
	 * wb_ƒl̃yA\NX
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	class HeaderValuePair {
		/** wb_ */
		private final String header_;
		/** wb_l */
		private final String value_;

		/**
		 * RXgN^
		 * @param header wb_
		 * @param value wb_l
		 */
		private HeaderValuePair(String header, String value) {
			header_ = header;
			value_ = value;
		}
		/**
		 * wb_Ԃ
		 * @return wb_
		 */
		private String getHeader() {
			return header_;
		}
		/**
		 * wb_lԂ
		 * @return wb_l
		 */
		private String getValue() {
			return value_;
		}
		/**
		 * wb_̕\Ԃ
		 * <wb_>: <l>
		 * ̌`
		 * @return wb_̕\
		 */
		public String toString() {
			return getHeader() + ": " + getValue();
		}
		/**
		 * IuWFNgmr
		 * L[ł΁CƂ݂Ȃ(wb_݂̂邽)
		 * @param o rΏۂ̃IuWFNg
		 * @return true: / false:Ⴄ
		 */
		public boolean equals(Object o) {
			if(o == null || o instanceof HeaderValuePair == false) {
				return false;
			}
			HeaderValuePair p = (HeaderValuePair)o;

			return getHeader().equals(p.getHeader());
		}
		/**
		 * nbVR[hԂ
		 * wb_̃nbVR[hԂ
		 * @return nbVR[h
		 */
		public int hashCode() {
			return getHeader().hashCode();
		}

	}
}
