/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ClientRequest.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.util.HashMap;
import java.util.Iterator;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.httpd.exception.*;

/**
 * NCAg̃NGXgi[IuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ClientRequest {
	/** HTTP\bh */
	private String method;
	/** vgR */
	private String protocol;
	/** o[W */
	private String version;
	/** NG[ */
	private String query;
	/** T[o[̋NIvV */
	private final Config config;

	/** wb_ */
	private HashMap header = new HashMap();

	/**
	 * RXgN^
	 * @param line NCAg瑗MĂ
	 */
	public ClientRequest(String line, Config c) throws HttpException {
		parser(line);
		config = c;
	}

	/**
	 * MĂNGXg𕪉
	 * @param line NGXg
	 */
	protected void parser(String line) throws HttpException {
		line = line.replaceAll("\r", "");
		String[] lines = line.split("\n");
		if(lines == null || lines.length == 0) {
			throw new HttpException(400,"request parameter is empty.");
		}
		String[] tokens = StringUtils.trimEmptyLines(lines[0].split(" "));

		// NGXg̏ GET / HTTP/1.1
		if(tokens.length < 2 || tokens.length > 3) {
			// g[N2菭ȂC3葽ꍇ͏G[
			throw new HttpException(400,line);
		}
		// \bh
		method = tokens[0].toUpperCase();
		// NG[
		query = tokens[1];
		// vgR
		String p = "HTTP/1.0";
		if(tokens.length >= 3) {
			p = tokens[2].toUpperCase();
		}
		String[] protocolAndVersion = p.split("/");
		if(protocolAndVersion.length != 2) {
			// vgR̃tH[}bgG[
			throw new HttpException(400,"invalid protocol format has been specified.");
		}
		protocol = protocolAndVersion[0];
		version = protocolAndVersion[1];

		// wb_̎荞
		int linecnt = 1;
		while(linecnt < lines.length) {
			String l = lines[linecnt++];
			// wb_̎荞
			int pos = l.indexOf(":");
			if(pos > 1) {
				String key = l.substring(0, pos).trim();
				String value = l.substring(pos+1).trim();
				// wb_ƂĎ荞
				header.put(key, value);
			}
		}
	}
	/**
	 * HTTP\bhԂ
	 * @return HTTP\bh
	 */
	public String getMethod() {
		return method;
	}
	/**
	 * vgRԂ
	 * @return vgR
	 */
	public String getProtocol() {
		return protocol;
	}
	/**
	 * HTTP̃o[WԂ
	 * @return HTTP̃o[W
	 */
	public String getVersion() {
		return version;
	}
	/**
	 * NG[Ԃ
	 * @return NG[
	 */
	public String getQuery() {
		return query;
	}
	/**
	 * T[o[̋NIvVԂ
	 * @return NIvV
	 */
	public Config getConfig() {
		return config;
	}
	/**
	 * wb_̃L[Ԃ
	 * @return L[i[RNVɑ΂Ce[^
	 */
	public Iterator headerKeys() {
		return header.keySet().iterator();
	}
	/**
	 * w肳ꂽwb_ɑ΂ݒlԂ
	 * @param key wb_
	 * @return ݒl(null:ݒ)
	 */
	public String getHeaderValue(String key) {
		return (String)header.get(key);
	}
}
