/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.SessionBindingListener;
import org.logical_paradox.common.session.SessionContext;
import org.logical_paradox.common.util.AttributeChangeListener;
import org.logical_paradox.common.util.DateTime;
import org.logical_paradox.common.util.ObservableAttribute;

public class Session
implements ObservableAttribute {
    public static final long DEFAULT_SESSION_LIFETIME = 20000L;
    private SessionBindingListener listener;
    private long expireDateTime;
    private long lifetime = 20000L;
    private final String sessionId;
    private SessionContext context = new SessionContext();
    private DateTime datetime = DateTime.getInstance();
    private boolean available = true;

    Session(String sid) throws IllegalSessionStateException {
        this.sessionId = sid;
        this.touch();
    }

    Session(String sid, long itv) throws IllegalSessionStateException {
        this(sid);
        this.lifetime = itv;
        this.touch();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionBindingListener(SessionBindingListener lsnr) throws IllegalSessionStateException {
        this.checkSessionState();
        this.listener = lsnr;
    }

    public void removeSessionBindingListener() throws IllegalSessionStateException {
        this.checkSessionState();
        this.listener = null;
    }

    void unbound() {
        if (this.listener != null) {
            this.listener.onUnBound();
        }
        this.available = false;
    }

    private void checkSessionState() throws IllegalSessionStateException {
        if (!this.available) {
            throw new IllegalSessionStateException("\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u6709\u52b9\u3067\u306a\u304f\u306a\u308a\u307e\u3057\u305f");
        }
    }

    public boolean isActive() {
        return this.datetime.currentTimeInMillis() <= this.expireDateTime;
    }

    void touch() throws IllegalSessionStateException {
        this.checkSessionState();
        this.expireDateTime = this.datetime.currentTimeInMillis() + this.lifetime;
    }

    void setSessionState(boolean state) throws IllegalSessionStateException {
        this.checkSessionState();
        this.available = state;
    }

    public boolean getSessionState() throws IllegalSessionStateException {
        this.checkSessionState();
        return this.available;
    }

    public void setAttributeChangeListener(String key, AttributeChangeListener lsnr) {
        this.context.setAttribute(key, lsnr);
    }

    public void removeAttributeChangeListener(String key) {
        this.context.removeAttributeChangeListener(key);
    }

    public Object getAttribute(String key) throws IllegalSessionStateException {
        this.touch();
        return this.context.getAttribute(key);
    }

    public void setAttribute(String key, Object o) throws IllegalSessionStateException {
        this.touch();
        this.context.setAttribute(key, o);
    }

    public void removeAttribute(String key) throws IllegalSessionStateException {
        this.touch();
        this.context.removeAttribute(key);
    }
}

