/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputOutputStreamPipe {
    public static int DEFAULT_BUFFER_SIZE = 16384;
    private final InputStream in_;
    private final OutputStream out_;
    private int bufferSize_ = DEFAULT_BUFFER_SIZE;

    public InputOutputStreamPipe(InputStream in, OutputStream out) {
        this.in_ = in;
        this.out_ = out;
    }

    public void throughAll() throws IOException, EOFException {
        byte[] buffer = new byte[this.getBufferSize()];
        int readByte = -1;
        while ((readByte = this.in_.read(buffer)) >= 0) {
            if (readByte <= 0) continue;
            this.out_.write(buffer, 0, readByte);
        }
        this.close();
    }

    public void setBufferSize(int bufsiz) {
        this.bufferSize_ = bufsiz;
    }

    public int getBufferSize() {
        return this.bufferSize_;
    }

    public void close() throws IOException {
        this.in_.close();
        this.out_.close();
    }
}

