/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.session;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.logical_paradox.common.util.StringUtils;

/**
 * ZbV}l[W[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class SessionManager {
	/** ZbVID̒ */
	public static final int SESSION_ID_LENGTH = 32;
	/** ZbVĎԊu(msec) */
	public static final int DEFAULT_SESSION_CHECK_INTERVAL = 1000;

	/** ZbV */
	public final HashMap sessions = new HashMap();
	/** ZbVpGC */
	private final SessionUnbounder unbounder;
	/** ZbV̐ */
	private long sessionLifeTime;

	/**
	 * RXgN^
	 */
	public SessionManager() {
		this(DEFAULT_SESSION_CHECK_INTERVAL);
	}
	/**
	 * RXgN^
	 * @param itv ZbVĎԊu
	 */
	public SessionManager(int itv) {
		unbounder = new SessionUnbounder(this, itv);
		unbounder.start();
	}
	/**
	 * RXgN^
	 * @param itv ZbVĎԊu
	 * @param lifetime ZbV̗L(msec)
	 */
	public SessionManager(int itv, long lifetime) {
		this(itv);
		sessionLifeTime = lifetime;
	}
	/**
	 * VZbVJn
	 * @return VǉꂽZbV
	 */
	public Session getSession() throws IllegalSessionStateException {
		String sessionId = null;

		// ZbVIDgpȂ悤ɂ
		while(true) {
			sessionId = getSessionId();
			if(sessions.get(sessionId) == null) {
				break;
			}
		}

		// VZbVǉ
		Session session = null;
		if(sessionLifeTime == 0) {
			session = new Session(sessionId);
		} else {
			session = new Session(sessionId, sessionLifeTime);
		}
		sessions.put(sessionId, session);
		
		return session;
	}
	/**
	 * VZbVJn
	 * w肳ꂽZbVID݂ꍇÃZbVp
	 * ݂ȂꍇAVZbVԂB̏ꍇAZbVID͎w肳ꂽ̂Ƃ͌Ȃ
	 * @param sessionId pvZbVID
	 * @return V쐬ꂽA܂͌pꂽZbVID
	 */
	public Session getSession(String sessionId) throws IllegalSessionStateException {
		synchronized(sessions) {
			Session session = (Session)sessions.get(sessionId);
			if(session == null) {
				// ̃ZbV݂Ȃ߁AVZbV쐬
				return getSession();
			} else {
				return session;
			}
		}
	}
	/**
	 * VZbVJn
	 * createModetruȅꍇAw肳ꂽZbVID݂ꍇÃZbVp
	 * ݂ȂꍇAVZbVԂB̏ꍇAZbVID͎w肳ꂽ̂Ƃ͌Ȃ
	 * createModefalsȅꍇÃZbV݂ȂꍇnullԂ
	 * @param sessionId pvZbVID
	 * @return V쐬ꂽA܂͌pꂽZbVID
	 */
	public Session getSession(String sessionId, boolean createMode) throws IllegalSessionStateException {
		if(createMode == true) {
			return getSession(sessionId);
		} else {
			synchronized(sessions) {
				return (Session)sessions.get(sessionId);
			}
		}
	}
	/**
	 * w肳ꂽZbV݂邩ǂԂ
	 * @return true:݂ / false:݂Ȃ(^CAEgȂ)
	 */
	public synchronized boolean isExists(String sessionId) {
		return sessions.get(sessionId) != null;
	}
	/**
	 * ZbV폜
	 * ZbV𐳂N[YCZbV}l[W[̊Ǘ
	 * @param sessionId ZbVID
	 */
	public synchronized void removeSession(String sessionId) {
		Session session = (Session)sessions.get(sessionId);
		if(session == null) {
			return;
		}

		session.unbound();
		sessions.remove(sessionId);
	}
	/**
	 * SẴZbV폜
	 * ZbV𐳂N[YCZbV}l[W[̊Ǘ
	 * @param sessions ZbṼXg
	 */
	public void removeAllSessions(List sessions) {
		for(Iterator it = sessions.iterator(); it.hasNext();) {
			Session session = (Session)it.next();
			removeSession(session.getSessionId());
		}
	}
	/**
	 * SẴZbVԂ
	 * @return SZbV
	 */
	synchronized Map getAllSessions() {
		return sessions;
	}
	/**
	 * ZbVIDԂ
	 * @return ZbVID
	 */
	private String getSessionId() {
		return StringUtils.randomText(SESSION_ID_LENGTH, true);
	}
}
