/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Multiplexer.java,v 1.8 2005/05/15 03:54:09 rampil Exp $
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;

/**
 * Multiplexer
 * }`vNT
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class Multiplexer {
	/**	T[o[\Pbgt@Ng̐ݒ薼 */
	public static final String KEY_SERVER_SOCKET_FACTORY = "serversocketfactory";
	/** NCAg\Pbgt@Ng̐ݒ薼 */
	public static final String KEY_CLIENT_SOCKET_FACTORY = "clientsocketfactory";
	/** |[gԍ */
	public static final String KEY_PORT_NUMBER = "portnumber";
	/** [gzXg(IPAhX܂̓zXg) */
	public static final String KEY_REMOTE_HOST = "remotehost";

	/** }`vNT̃^Cv - NCAg^Cv */
	public static final int MPX_MODE_CLIENT = 1;
	/** }`vNT̃^Cv - T[o[^Cv */
	public static final int MPX_MODE_SERVER = 100;

	/** ftHg̃\Pbg^CAEgb */
	public static final int DEFAULT_TIMEOUT_SEC = 1000 * 60 * 1;

	/** [gzXg(܂IPAhX) */
	private final String remoteHost;
	/** |[gԍ */
	private final int port;
	/** NCAgp̃\Pbg`l */
	private Vector clientChannels = new Vector();
	/** }`vNT */
	private final Selector selector;
	/** }`vNT̓샂[h */
	private final int mpxMode;
	/** \Pbg҂󂯃^CAEgb */
	private int liteningSocketTimeoutSec = DEFAULT_TIMEOUT_SEC;
	/** T[o[\Pbgt@Ng */
	private final CAsyncServerSocketFactory serverSocketFactory;
	/** NCAg\Pbgt@Ng */
	private final CAsyncClientSocketFactory clientSocketFactory;

	/**
	 * RXgN^
	 * @param mode \Pbg[h
	 * @param m p[^
	 * @throws IOException ʐMQ
	 */
	public Multiplexer(int mode, Map m) throws IOException {
		mpxMode = mode;
		if(mpxMode == MPX_MODE_SERVER) {
			remoteHost = "localhost";
		} else {
			remoteHost = (String)m.get(KEY_REMOTE_HOST);
		}
		// |[gԍ
		port = Integer.parseInt((String)m.get(KEY_PORT_NUMBER));
		// NCAg\Pbgt@Ng[
		clientSocketFactory = (CAsyncClientSocketFactory)m.get(KEY_CLIENT_SOCKET_FACTORY);
		// T[o[\Pbgt@Ng[
		serverSocketFactory = (CAsyncServerSocketFactory)m.get(KEY_SERVER_SOCKET_FACTORY);
		// ZN^[
		selector = SelectorProvider.provider().openSelector();
	}

	/**
	 * ̃}`vNTɑ΂āCĎΏۂ̃\Pbgǉ
	 * @param client NCAg\Pbg
	 * @param ops Zbg
	 * @throws TooManyListenersException Xi[ɑ݂ꍇɔO
	 * @throws IOException 炩̗RŃ`l̐ɎsꍇɔO
	 * @see java.nio.channels.SelectionKey
	 */
	public void addChannel(CAsyncSocket client, int ops) throws TooManyListenersException, IOException {
		client.addEventListener(client);
		client.configureBlocking(false);		// mubLO[h(:registerĂяoOɎs邱)
		client.register(selector, ops);
		clientChannels.addElement(client);
	}
	/**
	 * ̃}`vNTɑ΂āCĎΏۂ̃\Pbgǉ
	 * @param ops Zbg
	 * @throws TooManyListenersException Xi[ɑ݂ꍇɔO
	 * @throws IOException 炩̗RŃ`l̐ɎsꍇɔO
	 * @see java.nio.channels.SelectionKey
	 */
	public void addChannel(int ops) throws TooManyListenersException, IOException {
		CAsyncSocket client = null;
		switch(mpxMode) {
			case MPX_MODE_CLIENT:
				client = clientSocketFactory.createClientSocket(remoteHost, port);
				break;
			case MPX_MODE_SERVER:
				client = serverSocketFactory.createServerSocket(port);
				break;
			default:
				throw new IllegalArgumentException("}`vNT: \Pbg̍쐬Ɏs");
		}

		addChannel(client, ops);
	}
	/**
	 * ݓo^Ă`lԂ
	 * @return `l̔z
	 */
	public Vector getChannels() {
		return clientChannels;
	}
	/**
	 * Ms
	 * @throws Exception MɔO
	 */
	public void doWork() throws Exception {
		int nofk = selector.select();
		if(nofk <= 0) {
			return;
		}
		Iterator it = selector.selectedKeys().iterator();

		while(it.hasNext()) {
			SelectionKey key = (SelectionKey)it.next();
			it.remove();

			AsyncEventListener callback = (AsyncEventListener)key.attachment();
			if(callback != null) {
				if(key.isConnectable()) {
					if(key.channel() instanceof SocketChannel) {
						SocketChannel sockch = (SocketChannel)key.channel();
						if(sockch.isConnectionPending() == true) {
							sockch.finishConnect();
							// ڑCxg
							callback.onConnect(new AsyncEvent(this, key.channel()));
						}
					}
				} else if(key.isReadable()) {
					// ǂݍ݉\Cxg
					callback.onReceive(new AsyncEvent(this, key.channel()));
				} else if(key.isWritable()) {
					// ݉\Cxg
					callback.onSend(new AsyncEvent(this, key.channel()));
				} else if(key.isAcceptable()) {
					ServerSocketChannel server = (ServerSocketChannel)key.channel();
					SocketChannel client = server.accept();
					addChannel(clientSocketFactory.createClientSocket(client), SelectionKey.OP_CONNECT | SelectionKey.OP_READ | SelectionKey.OP_WRITE);

					// tCxg
					callback.onAccept(new AsyncEvent(this, client));
				}
			}
		}
	}
}

// end of Multiplexer.java
