/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: CAsyncSocket.java,v 1.6 2005/05/15 12:37:53 rampil Exp $
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.TooManyListenersException;

import org.logical_paradox.common.net.ReadWriteBuffer;

/**
 * CAsyncSocket
 * so͂\non-blocking^Cṽ\Pbg
 * \Pbĝ悤ȓ邪C̓\Pbgł͂ȂD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public abstract class CAsyncSocket implements AsyncEventListener {
	/** Mobt@̃TCY */
	public static final int SEND_BUFFER_SIZE = 4096;
	/** Mobt@̃TCY */
	public static final int RECEIVE_BUFFER_SIZE = 4096;

	protected SelectableChannel channel = null;
	protected AsyncEventListener listener = null;

	/** ǂݏ\ȃobt@(Mobt@) */
	private ReadWriteBuffer sendBuffer = new ReadWriteBuffer();
	/** ǂݏ\ȃobt@(Mobt@) */
	private ReadWriteBuffer receiveBuffer = new ReadWriteBuffer();

	/**
	 * RXgN^
	 */
	public CAsyncSocket() {
	}

	/*
	 * Cxgnh̓o^ƍ폜
	 */
	public void addEventListener(AsyncEventListener l) throws TooManyListenersException {
		if( listener != null ) {
			throw new TooManyListenersException( "AsyncEventListener͊ɓo^Ă܂" );
		}
		listener = l;
	}
	public void removeEventListener() {
		listener = null;
	}

	/**
	 * }`vNTɂ̃\Pbg
	 * @param s ZN^[
	 * @param o Zbg
	 * @return L[
	 * @throws ClosedChannelException `lĂꍇɔO
	 * @see java.nio.channels.SelectionKey
	 */
	public SelectionKey register(Selector s, int o) throws ClosedChannelException {
		SelectionKey skey = channel.register(s, o);
		skey.attach(listener);				// ZNVL[ɃCxgnh

		return skey;
	}

	/**
	 * ubLO[hݒ肷
	 * @param mode true:ubLO[h / false: ubLO[h
	 * @throws IOException ݒɎsꍇɔO
	 */
	public void configureBlocking(boolean mode) throws IOException {
		if(channel != null) {
			channel.configureBlocking(mode);
		}
	}
	/**
	 * \Pbg`lԂ
	 * @return \Pbg`l
	 */
	public SelectableChannel getSelectableChannel() {
		return channel;
	}

	/**
	 * w肳ꂽ\Pbg`lCǂݍ݃obt@ɑ΂ăf[^ǂݍ
	 * @param src
	 */
	protected void readMessage( SocketChannel src ) {
		ByteBuffer rb = ByteBuffer.allocate( 4096 );
		try {
			src.read( rb );
			rb.flip();
			Charset charset = Charset.forName( "MS932" );
			CharsetDecoder csdecoder = charset.newDecoder();
			CharBuffer cb = csdecoder.decode( rb );
		} catch( IOException ae ) {
		}
	}
	/**
	 * Mobt@ɑ΂ăf[^
	 * Mobt@̓e̓\PbgM\ԂɂȂۂɑM
	 * @param b MΏۃf[^
	 */
	public void sendMessage(byte[] b) {
		sendBuffer.write(b);
		onSend(new AsyncEvent(this,channel));
	}
	/**
	 * \Pbgǂݍ݉\ԂɂȂۂɌĂ΂Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void onReceive(AsyncEvent o) {
		try {
			SocketChannel channel = (SocketChannel)o.getChannel();
			ByteBuffer bb = ByteBuffer.allocate(RECEIVE_BUFFER_SIZE);
		} catch(Exception e) {
		}
	}
	/**
	 * \Pbg݉\ԂɂȂۂɌĂ΂Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void onSend(AsyncEvent o) {
		// Mobt@ɗ܂Ăe\Pbgɑ΂đM
		byte[] sendbuf = new byte[SEND_BUFFER_SIZE];
		int sendsize = 0;
		while((sendsize = sendBuffer.read(sendbuf)) > 0) {
			// Mobt@ɉi[ĂԁCM
			ByteBuffer bb = null;
			try {
				bb = ByteBuffer.wrap(sendbuf, 0, sendsize);
				((SocketChannel)o.getChannel()).write(bb);
			} catch(Exception e) {
				// ʐMG[
			} finally {
				if(bb != null) {
					bb.clear();
					bb = null;
				}
			}
		}
	}

}

// end of CAsyncSocket.java
