/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: CAsyncClientSocket.java,v 1.3 2005/05/04 07:49:56 rampil Exp $
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

/**
 * CAsyncClientSocket
 * so͂\non-blocking^Cṽ\Pbg
 * \Pbĝ悤ȓ邪C̓\Pbgł͂ȂD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class CAsyncClientSocket extends CAsyncSocket {
	/** ڑ̃T[o[(IPAhX܂̓zXg) */
	private final String remoteHost;
	/** |[gԍ */
	private int port;
	/** Cxgnh */
	private AsyncEventListener listener = null;

	/**
	 * RXgN^
	 * ɃI[vꂽ\Pbg`l݂ꍇɎgp
	 * @param ch \Pbg`l
	 */
	public CAsyncClientSocket(SocketChannel ch) throws IOException {
		remoteHost = "";
		channel = (SelectableChannel)ch;
	}
	/**
	 * RXgN^
	 * CX^XɎwzXgɐڑs
	 * @param server [gzXg(܂IPAhX)
	 * @param port |[gԍ
	 * @throws IOException T[o[ւ̐ڑɎs
	 */
	public CAsyncClientSocket(String server, int p) throws IOException {
		remoteHost = server;
		port = p;
		channel = (SelectableChannel)SocketChannel.open(new InetSocketAddress(remoteHost, port));
	}
	/**
	 * ̃NCAgT[o[ɐڑۂɌĂяoCxgnh
	 * TuNXŎ
	 * @param e CxgIuWFNg
	 */
	public abstract void onConnect(AsyncEvent e);
	/**
	 * \Pbgǂݍ݉\ԂɂȂۂɌĂяoCxgnh
	 * TuNXł͂̃\bhI[o[ChĎ邱
	 * @param e CxgIuWFNg
	 */
	public abstract void onReceive(AsyncEvent e);

	/**
	 * ̃NCAgM\ԂɂȂۂɌĂяoCxgnh
	 * ʏ킱̃\bh̓I[o[ChKv͂Ȃ
	 * @param e CxgIuWFNg
	 */
	public void onSend(AsyncEvent e) {
		super.onSend(e);
	}
	/**
	 * T[o[ւ̐ڑmۂɌĂ΂Cxgnh
	 * ̃nh̓NCAg\Pbgɂ͕KvȂ
	 * @param e CxgIuWFNg
	 */
	public void onAccept(AsyncEvent e) {
	}
}

// end of CAsyncClientSocket.java
