/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

/**
 * HTTPNGXgM[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class HttpRequestSender {
	/**
	 * wURLɑ΂POSTőM
	 * @param url ڑURL
	 * @param data Mf[^()
	 * @return HTTPT[o[̃X|X
	 * @throws IOException ʐMG[
	 */
	public static InputStream post(String url, String data) throws IOException {
		URL server = new URL(url);
		URLConnection con = server.openConnection();
		con.setDoOutput(true);

		PrintWriter pw = new PrintWriter(con.getOutputStream());
		pw.print(data);
		pw.flush();
		pw.close();

		return con.getInputStream();
	}
	/**
	 * vpeBURLGR[hɕϊĕԂ
	 * @param parameters vpeB
	 * @param encoding GR[fBO
	 * @return URLGR[hꂽ
	 */
	public static String urlEncodeAll(Properties parameters, String encoding) throws UnsupportedEncodingException {
		Enumeration e = parameters.keys();
		StringBuffer sb = new StringBuffer();

		while(e.hasMoreElements()) {
			String key = (String)e.nextElement();
			String value = (String)parameters.get(key);

			if(sb.length() > 0) {
				sb.append("&");
			}
			sb.append(urlEncode(key, value, encoding));
		}

		return sb.toString();
	}
	/**
	 * URL`ɃGR[hԂ
	 * @param key L[
	 * @param value l
	 * @param encoding GR[fBO
	 * @return GR[hꂽ
	 */
	public static String urlEncode(String key, String value, String encoding) throws UnsupportedEncodingException {
		return URLEncoder.encode(key, encoding) + "=" + URLEncoder.encode(value, encoding);
	}
}
