/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.lang;

import java.io.Serializable;

import org.logical_paradox.common.io.ByteStream;

/**
 * ϒ`ŃoCgϊ\Number
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class VariableFormatNumber extends Number implements Serializable, ByteStream {
	private final long value;
	
	/**
	 * RXgN^
	 * w肳ꂽoCg񂩂ϒ𕜌
	 * @param bstream oCg(ϒ`)
	 */
	public VariableFormatNumber(byte[] bstream) {
		value = byteStreamToLongValue(bstream, 0);
	}
	/**
	 * RXgN^
	 * w肳ꂽoCg񂩂ϒ𕜌
	 * @param bstream oCg(ϒ`)
	 * @param offset JnItZbg
	 */
	public VariableFormatNumber(byte[] bstream, int offset) {
		value = byteStreamToLongValue(bstream, offset);
	}
	/**
	 * RXgN^
	 * @param intval 
	 */
	public VariableFormatNumber(int intval) {
		value = (long)intval & 0x00000000ffffffff;
	}
	/**
	 * RXgN^
	 * @param longval 
	 */
	public VariableFormatNumber(long longval) {
		value = longval;
	}
	/**
	 * RXgN^
	 * @param floatval Pxl
	 */
	public VariableFormatNumber(float floatval) {
		value = (long)floatval;
	}
	/**
	 * RXgN^
	 * @param doubleval {xl
	 */
	public VariableFormatNumber(double doubleval) {
		value = (long)doubleval;
	}
	/**
	 * intlԂ
	 * @return l
	 */
	public int intValue() {
		return (int)value & 0x00000000ffffffff;
	}
	/**
	 * longlԂ
	 * @return l
	 */
	public long longValue() {
		return value;
	}
	/**
	 * floatlԂ
	 * @return Pxl
	 */
	public float floatValue() {
		return (float)value;
	}
	/**
	 * doubleԂ
	 * @return {xl
	 */
	public double doubleValue() {
		return (double)value;
	}
	/**
	 * ϒ`̃oCgԂ
	 * @return oCg(ϒ`)
	 */
	public byte[] byteStream() {
		byte[] tmp = new byte[16];
		int cnt = 15;
		long copy = value;

		while(copy != 0) {
			tmp[cnt] = (byte)(copy & 0x7f);
			copy /= 128;
			if(cnt != 15) {
				tmp[cnt] |= 0x80;
			}
			cnt--;
		}
		byte[] result = new byte[15-cnt];
		if(result.length == 0) {
			// 0̏ꍇ
			return new byte[1];
		}
		// ȊȌꍇ
		System.arraycopy(tmp, cnt+1, result, 0, 15-cnt);
		return result;
	}
	/**
	 * oCg񂩂琮𕜌
	 * @param bstream oCg
	 * @param offset JnItZbg
	 * @return l
	 */
	private long byteStreamToLongValue(byte[] bstream,int offset) {
		long value = 0;
		int i = offset;
		boolean loopf = true;
		
		while(loopf) {
			value += bstream[i] & 0x7f;
			if((bstream[i] & 0x80) == 0) {
				// ŏʃrbg0Ȃ̂ŁCꂪŌ̃oCg
				loopf = false;
			} else {
				// ̃oCg͂Ȃ̂ŁC7bitVtg
				value <<= 7;
			}
			i++;
		}

		return value;
	}
}
