/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 */
package org.logical_paradox.common.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.logical_paradox.common.io.ByteStream;

/**
 * oCg񉻉\Longbp[
 * oCg񉻂ꍇCLongBIG_ENDIANŊi[
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class LongByteStream implements ByteStream {
	private final Long value;
	private final byte[] bstream;

	/**
	 * RXgN^
	 * @param l lIuWFNg
	 */	
	public LongByteStream(Long l) {
		value = l;
		bstream = objectToByteStream(l.longValue());
	}
	/**
	 * RXgN^
	 * @param l l
	 */
	public LongByteStream(long l) {
		this(new Long(l));
	}
	/**
	 * Long^̃IuWFNgԂ
	 * @return lIuWFNg
	 */
	public Long getLongObject() {
		return value;
	}
	/**
	 * longlԂ
	 * @return l
	 */
	public long longValue() {
		return value.longValue();
	}
	/**
	 * ̃IuWFNgoCgɕϊĕԂ
	 * oCgւ̕ΐCRXgN^ĂяoɍsĂ̂ŁC
	 * ł͒PɂԂ
	 * @return oCg
	 */
	public byte[] byteStream() {
		return bstream;
	}
	/**
	 * lIuWFNgoCg֕ϊĕԂ
	 * @param l l
	 * @return oCg
	 */
	protected byte[] objectToByteStream(long l) {
		ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
		buffer.rewind();
		buffer.putLong(l);
		
		return buffer.array();
	}
}

// end of LongByteStream.java
