/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NodeTest.java,v 1.2 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.object;

import java.util.Random;

import junit.framework.TestCase;

/**
 * m[hIuWFNgƂɊ֘A郍WbÑeXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class NodeTest extends TestCase {

	/**
	 * Constructor for NodeTest.
	 * @param arg0
	 */
	public NodeTest(String arg0) {
		super(arg0);
	}
	/**
	 * m[hm̔r
	 */
	public void testEquals() {
		assertEquals(new Node(1,0,0), new Node(1,0,0));
		assertEquals(new Node(1,-1,0), new Node(1,-1,0));
		assertEquals(new Node(10000,-1,-1), new Node(10000,-1,-1));
		assertFalse(new Node(10001,-1,-1).equals(new Node(10000,-1,-1)));
		assertFalse(new Node(1,5,0).equals(new Node(1,0,0)));
		assertFalse(new Node(1,0,0).equals(new Node(1,0,5)));
	}
	/**
	 * contains()\bh̃eXg
	 * w肵m[hm[hXgɐi[Ă邱Ƃoł邩ǂ
	 */
	public void testContains() {
		Node node = new Node(0, 100,200);
		Node n1 = new Node(2, 200,300);
		Node n2 = new Node(3,400,500);
		Node n3 = new Node(4,600,700);

		Node f1 = new Node(5,200,999);

		node.add(n1);
		node.add(n2);
		node.add(n3);

		assertTrue(node.contains(n1));
		assertTrue(node.contains(n2));
		assertTrue(node.contains(n3));

		assertFalse(node.contains(f1));

		Node c1 = new Node(2,200,300);
		Node c2 = new Node(999,400,500);

		assertTrue(node.contains(c1));
		assertFalse(node.contains(c2));
	}
	/**
	 * hug̃eXg
	 * <li>hug̃m[hXgɎ̃m[ho^Ă邱</li>
	 * <li>hug̃m[h̃m[hXgɐo^Ă邱</li>
	 * mF
	 *
	 */
	public void testHug() {
		Node me = new Node(100, 500, 999);
		Node buddy = new Node(256, 512, 1024);

		assertEquals(0, me.getRelativeNodes().size());
		assertEquals(0, buddy.getRelativeNodes().size());

		buddy.hug(me);
		me.add(buddy);

		assertEquals(1, me.getRelativeNodes().size());
		assertEquals(1, buddy.getRelativeNodes().size());
		assertTrue(me.getRelativeNodes().get(0) == buddy);
		assertTrue(buddy.getRelativeNodes().get(0) == me);
	}
	/**
	 * KɃm[hǉ
	 * 1m[hǉ邲ƂɁAœKm[hIs
	 * OȂOK
	 */
	public void testRandomConfigure() {
		Node node = new Node(1, 320, 128);
		Random r = new Random();

		int loopCount = Math.abs(r.nextInt()) % 500 + 500;
		for(int i = 0; i < loopCount; i++) {
			node.add(new Node(100+i, Math.abs(r.nextInt()) % 640, Math.abs(r.nextInt()) % 480));
			node.configure();
		}
	}
	/**
	 * KɃm[hAԂŁAœKm[hIs
	 * SẴm[hɂāAƓm[h܂܂ĂȂOK
	 * ܂Cm[hA̍œKm[hIɂāAm[hNێȂȂꍇ̓G[Ƃ
	 */
	public void testConnectivity() {
		Random r = new Random();
		Node[] nodes = new Node[Math.abs(r.nextInt()) % 100 + 100];
		for(int i = 0; i < nodes.length; i++) {
			nodes[i] = new Node(i+1, Math.abs(r.nextInt()) % 640, Math.abs(r.nextInt()) % 480);
		}

		// _ɘA
		for(int i = 0; i < nodes.length; i++) {
			int loopCount = Math.abs(r.nextInt() % 25 + 5);
			while(loopCount > 0) {
				int nno = Math.abs(r.nextInt()) % nodes.length;
				if(nno == i) {
					continue;					// g͘AȂ
				}
				nodes[i].hug(nodes[nno]);		// hug
				loopCount--;
			}
			// œKm[hI
			nodes[i].configure();
		}

		// AԂ̑Ó
		for(int i = 0; i < nodes.length; i++) {
			// Ɠm[hi[ĂȂǂmF
			assertFalse(nodes[i].contains(nodes[i]));
			// N؂ꂪȂ󋵂Ȃ̂ŁAN؂mF
			assertTrue(nodes.length <= 1 || nodes[i].getRelativeNodes().size() > 0);
		}
	}
}
