/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MetricTest.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.object;

import java.util.ArrayList;
import java.util.Collections;

import junit.framework.TestCase;

/**
 * gbNIuWFNg̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class MetricTest extends TestCase {

	/**
	 * Constructor for MetricTest.
	 * @param arg0
	 */
	public MetricTest(String arg0) {
		super(arg0);
	}

	/**
	 * gbNm̑召r̃eXg(l)
	 */
	public void testCompareMetricsEquals() {
		Metric m1 = new Metric(100.213, null);
		Metric m2 = new Metric(100.213, null);

		assertEquals(0, m2.compareTo(m1));
	}
	/**
	 * gbNm̑召r̃eXg()
	 */
	public void testCompareMetricsLessThan() {
		Metric m1 = new Metric(100.213, null);
		Metric m2 = new Metric(100.212, null);

		assertEquals(-1, m2.compareTo(m1));
	}
	/**
	 * gbNm̑召r̃eXg(傫)
	 */
	public void testCompareMetricGreaterThan() {
		Metric m1 = new Metric(100.213, null);
		Metric m2 = new Metric(100.215, null);

		assertEquals(1, m2.compareTo(m1));
	}
	/**
	 * R\[g
	 */
	public void testMetricsSorting() {
		Metric m1 = new Metric(100.213, null);
		Metric m2 = new Metric(100.215, null);
		Metric m3 = new Metric(99.2, null);
		Metric m4 = new Metric(103.213,null);

		ArrayList list = new ArrayList();
		list.add(m1);
		list.add(m2);
		list.add(m3);
		list.add(m4);

		Collections.sort(list);
		
		assertTrue(m3 == list.get(0));
		assertTrue(m1 == list.get(1));
		assertTrue(m2 == list.get(2));
		assertTrue(m4 == list.get(3));
	}
}
