/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NodePropertyDialog.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.view;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JDialog;

import org.logical_paradox.testsite.oln.object.AppContext;
import org.logical_paradox.testsite.oln.object.RequestContext;

/**
 * m[h_CAO
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class NodePropertyDialog extends JDialog {
	/** _CAO[h: VK */
	public static final int MODE_NEW = 1;
	/** _CAO[h: XV */
	public static final int MODE_CHANGE = 100;

	/** _CAỎTCY */
	public static final int DLG_WND_WIDTH = 320;
	/** _CAȌcTCY */
	public static final int DLG_WND_HEIGHT = 128;

	/** _CAO[h */
	private final int mode;

	/** AvP[VReLXg */
	private final AppContext context_;
	/** NGXgReLXg */
	private final RequestContext request_;
	
	/**
	 * RXgN^
	 * [__CAOŏ
	 */
	public NodePropertyDialog(String dlgTitle, int m, AppContext context, RequestContext request) {
		super(context.getFrame(), true);
		mode = m;
		context_ = context;
		request_ = request;

		setTitle(dlgTitle);

		// _CAOTCYȂǂ̏
		init();
	}
	/**
	 * _CAȌ
	 */
	protected void init() {
		Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation(((int)windowLocation.getWidth() - DLG_WND_WIDTH) /2, ((int)windowLocation.getHeight() - DLG_WND_HEIGHT) /2);
		setSize(new Dimension(DLG_WND_WIDTH, DLG_WND_HEIGHT));
		setVisible(true);
	}
}
