/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MainWndGeneralPopupMenu.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.view;

import javax.swing.JMenuItem;
import org.logical_paradox.testsite.oln.model.handler.AdditionNewNodeBtnListener;
import org.logical_paradox.testsite.oln.model.handler.RemoveNodeBtnListener;
import org.logical_paradox.testsite.oln.object.AppContext;
import org.logical_paradox.testsite.oln.object.RequestContext;

/**
 * g|W[r[ł̈ʓIȃ|bvAbvj[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class MainWndGeneralPopupMenu extends OlnBasePopupMenu {
	/**
	 * RXgN^
	 * @param context AvP[VReLXg
	 * @param request NGXgReLXg
	 */
	public MainWndGeneralPopupMenu(AppContext context, RequestContext request) {
		super("General", context, request);
		init();
	}
	/**
	 * j[ACe
	 */
	protected void init() {
		// VKm[hǉ
		JMenuItem mAddNewNode = new JMenuItem("Add new node");
		mAddNewNode.addActionListener(new AdditionNewNodeBtnListener(getAppContext(), getRequestContext()));
		// Sm[h폜
		JMenuItem mRemoveNode = new JMenuItem("Remove selected nodes");
		mRemoveNode.addActionListener(new RemoveNodeBtnListener(getAppContext(), getRequestContext()));
		if(getAppContext().getTopology().isSelected() == false) {
			// m[hȈꍇ̓j[𖳌ɂ
			mRemoveNode.setEnabled(false);
		}
		// r[ĕ`
		JMenuItem mUpdateView = new JMenuItem("Refresh topology view");

		// j[ACe|bvAbvj[ɒǉ
		add(mAddNewNode);
		add(mRemoveNode);
		addSeparator();
		add(mUpdateView);
	}
}
