/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Topology.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.object;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * I[o[Clbg[Ñg|WǗIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Topology {
	/** lbg[NɔzuĂm[h̃Xg */
	private ArrayList nodes = new ArrayList();
	/** ɍ쐬m[hԍ */
	private int nextNodeId = 0;
	/** Ulbg[NɔzĂSẴm[hSɂȂĂ邩ǂ */
	private boolean connectivity = false;
	/** Ulbg[N̕G(1m[h̃Nێ) */
	private double complex = 0.0;
	/** Ulbg[NɔzuĂm[hōŏ̃N */
	private int min;
	/** Ulbg[NɔzuĂm[hōő̃N */
	private int max;

	/**
	 * lbg[NɐVm[hǉ
	 */
	public void deployNewNode(int x, int y) {
		Node node = new Node(nextNodeId++, x, y);
		// IĂm[hꍇASẴm[hhug
		// Im[hǉꍇAIԂ
		for(Iterator it = nodes.iterator(); it.hasNext();) {
			Node n = (Node)it.next();
			if(n.isSelected()) {
				node.add(n);
				n.setSelected(false);
				n.hug(node);
			}
		}
		// œKm[hI
		node.configure();
		nodes.add(node);

		// lbg[Nɕω߁Cg|Ws
		researchConnectivity();
	}
	/**
	 * w肳ꂽʒuɑ݂m[h1Ԃ
	 * @param index Xg̃CfbNX
	 * @return m[h
	 */
	public Node getNode(int index) {
		return (Node)nodes.get(index);
	}
	/**
	 * w肳ꂽʒuɑ݂m[h1Ԃ
	 * ݂ȂꍇnullԂ
	 * @param point
	 */
	public Node getNode(Point point) {
		for(Iterator it = iteratorNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			if(node.getSelectableRectangle().contains(point)) {
				return node;
			}
		}
		return null;
	}
	/**
	 * ݑIԂ̑SẴm[h
	 */
	public void removeSelectedNodes() {
		for(Iterator it = nodes.iterator(); it.hasNext();) {
			Node node = (Node)it.next();
			if(node.isSelected()) {
				// Ulbg[N痣E
				node.disconnect();
				it.remove();
			}
		}
		// lbg[Nɕω߁Cg|Ws
		researchConnectivity();
	}
	/**
	 * wm[h𕪎Ulbg[N珜
	 * @param node m[h
	 */
	public void removeNode(Node node) {
		node.disconnect();
		nodes.remove(node);
		researchConnectivity();
	}
	/**
	 * g|W[SɈێĂ邩ǂԂ
	 * @return true:SɈێĂ / false:lbg[NǂŕfĂ
	 */
	public boolean isCompleteConnectivity() {
		return connectivity;
	}
	/**
	 * Ulbg[NɔzuĂm[hōŏ̃NԂ
	 * @return N
	 */
	public int getMinNodeCount() {
		return min;
	}
	/**
	 * Ulbg[NɔzuĂm[hōő̃NԂ
	 * @return N
	 */
	public int getMaxNodeCount() {
		return max;
	}
	/**
	 * lbg[N̕GԂ
	 * @return G
	 */
	public double getComplex() {
		return complex;
	}
	/**
	 * Sm[hɑ΂āAœKm[hI̎sʒm
	 */
	public void configureAll() {
		for(Iterator it = nodes.iterator(); it.hasNext();) {
			Node node = (Node)it.next();
			node.configure();
		}
	}
	/**
	 * ̃g|W[̕\Ԃ
	 * \ɂ́Ag|WɊւ񂪊܂܂Ă
	 */
	public String toString() {
		return nodes.size() + "nodes, " + getComplex() + " cplx, " + getMinNodeCount() + " (min), " + getMaxNodeCount() + " (max)";
	}
	/**
	 * ݂̃lbg[N̐ڑɂĒ
	 * @return true:SɈێĂ / false:lbg[NǂŕfĂ
	 */
	public boolean researchConnectivity() {
		if(nodes.size() == 0) {
			connectivity = false;
		} else {
			// Cg[Xs
			LineTracer tracer = new LineTracer((Node)nodes.get(0));
			tracer.run();
			// ǗĂm[h݂悤ł΁AǂŕfĂ
			ArrayList all = new ArrayList();
			all.addAll(nodes);
			all.removeAll(tracer.getTracedNodes());

			// ݃lbg[Nɑ݂m[ĥCg[Xł̂
			connectivity = all.size() == 0;
			complex = tracer.getComplex();
			min = tracer.getMinNodeCount();
			max = tracer.getMaxNodeCount();
		}

		return isCompleteConnectivity();
	}
	/**
	 * m[hXg̎wCfbNX̃m[hԂ
	 * @param index CfbNX
	 * @return m[h
	 */
	public Node get(int index) {
		return (Node)nodes.get(index);
	}
	/**
	 * [hXg̃TCYԂ
	 * @return m[hXg̃TCY
	 */
	public int getNodeListSize() {
		return nodes.size();
	}
	/**
	 * m[hXgԂ
	 * @return m[hXg
	 */
	public Iterator iteratorNodes() {
		return nodes.iterator();
	}
	/**
	 * 1ȏ̃m[hIĂ邩ǂԂ
	 * @return true:I / false:I
	 */
	public boolean isSelected() {
		for(Iterator it = nodes.iterator(); it.hasNext();) {
			Node node = (Node)it.next();
			if(node.isSelected()) {
				return true;
			}
		}
		return false;
	}
	/**
	 * SẴm[h̑IԂ
	 */
	public void deSelectAll() {
		for(Iterator it = iteratorNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			node.setSelected(false);
		}
	}
	/**
	 * m[hg[X郍{bg
	 * wm[hN_ƂČE܂Ńm[hg[X
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.3 $
	 */
	class LineTracer {
		/** g[X̊Jn_ */
		private final Node startPoint_;
		/** m[hԂ̃N */
		private int connections_;
		/** ŏm[h */
		private int min = 100000000;
		/** őm[h */
		private int max = 0;
		/** ۂɃg[Xm[h */
		private final List tracedNodes_ = new ArrayList();

		/**
		 * RXgN^
		 * @param node g[X̊Jn_
		 */
		private LineTracer(Node node) {
			startPoint_ = node;
		}
		/**
		 * g[XJn
		 */
		private void run() {
			if(startPoint_ == null) {
				// Jn_ɋȂ̂ŏI
				return;
			}
			trace(startPoint_);
		}
		/**
		 * g[X
		 * @param node ݈Ăm[h
		 */
		private void trace(Node node) {
			// ̃m[h𓥔jς݂ƂĐɓo^Ă
			if(tracedNodes_.contains(node)) {
				return;
			}
			tracedNodes_.add(node);
			// ̃m[hێĂ郊NɂāCSĒT
			int nodeCount = node.getRelativeNodes().size();
			connections_ += nodeCount;
			if(min > nodeCount) {
				min = nodeCount;
			}
			if(max < nodeCount) {
				max = nodeCount;
			}
			Collection link = node.getRelativeNodes();
			for(Iterator it = link.iterator(); it.hasNext();) {
				Node n = (Node)it.next();
				// ɒTi߂
				trace(n);
			}
		}
		/**
		 * g[Xꂽm[h̃XgԂ
		 * @return g[Xꂽm[h̃Xg
		 */
		private List getTracedNodes() {
			return tracedNodes_;
		}
		/**
		 * őm[hԂ
		 * @return őm[h
		 */
		private int getMaxNodeCount() {
			return max;
		}
		/**
		 * ŏm[hԂ
		 * @return ŏm[h
		 */
		private int getMinNodeCount() {
			return min;
		}
		/**
		 * lbg[N̕GԂ
		 * @return lbg[N̕G
		 */
		private double getComplex() {
			return getTracedNodes().size() == 0 ? 0 : connections_ / getTracedNodes().size();
		}
	}
}
