/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Node.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.object;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.logical_paradox.testsite.oln.OverlayNetworkConstant;
import org.logical_paradox.testsite.oln.model.RoutingAlgorithm;
import org.logical_paradox.testsite.oln.model.RoutingAlgorithmFactory;

/**
 * I[o[Clbg[NɔzuĂm[h
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Node extends Point {
	/** m[hID */
	private int nodeNo;
	/** ֘AÂĂm[h̃Xg */
	private ArrayList relativeNodes = new ArrayList();
	/** ̃m[hIĂ邩ǂ(true:Iς / false:I) */
	private boolean selected = false;
	/** ̃m[h}[NĂ邩ǂ(true:}[Nς / false:}[NĂȂ) */
	private boolean marked = false;

	/** [eBOASY */
	private final RoutingAlgorithm algorithm;

	/**
	 * RXgN^
	 * @param nodeId m[hID
	 * @param x m[hXW
	 * @param y m[hYW
	 */
	public Node(int nn, int x, int y) {
		super(x, y);
		nodeNo = nn;
		algorithm = RoutingAlgorithmFactory.getDefaultAlgorithm(this);
	}

	/**
	 * m[hIDԂ
	 * @return m[hID
	 */
	public int getNodeNo() {
		return nodeNo;
	}

	/**
	 * m[hmr
	 * @param o rΏ
	 * @return true: / false:Ⴄ
	 */
	public boolean equals(Object o) {
		Node node = (Node)o;

		return node.x == x && node.y == y && node.nodeNo == nodeNo;
	}
	/**
	 * Ulbg[N痣E
	 */
	public void disconnect() {
		algorithm.notifyDisconnect();
	}
	/**
	 * wm[hm[hXgɑ݂邩ǂԂ
	 * @param node m[h
	 * @return true: / false:Ȃ
	 */
	public boolean contains(Node node) {
		return relativeNodes.contains(node);
	}
	/**
	 * m[hXgɑ݂SĂ̐ڑ肪C̃m[h̎QƂێĂ邩؂
	 * @return true:ێĂ / false:ێĂȂ
	 */
	public boolean isHoldByBuddies() {
		for(Iterator it = iteratorRelativeNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			if(node.contains(this) == false) {
				return false;
			}
		}
		return true;
	}
	/**
	 * HUG
	 * @param node HUG
	 * @return true: / false:s
	 */
	public boolean hug(Node node) {
		return algorithm.hug(node);
	}
	/**
	 * m[hXgɒǉ
	 * @param node ǉm[h
	 */
	public void add(Node node) {
		relativeNodes.add(node);
	}
	/**
	 * m[hXgɈxɒǉ
	 * @param nodes ǉm[h̃Xg
	 */
	public void addAll(Collection nodes) {
		relativeNodes.addAll(nodes);
	}
	/**
	 * m[hXg폜
	 * @param node 폜m[h
	 */
	public void remove(Node node) {
		relativeNodes.remove(node);
	}
	/**
	 * wʒuփm[hړ
	 * @param point ړW
	 */
	public void move(Point point) {
		setLocation(point.getX(), point.getY());
		configure();
	}
	/**
	 * m[hXg
	 */
	public void clear() {
		relativeNodes.clear();
	}
	/**
	 * ̃m[h}[NĂ邩ǂԂ
	 * @return true: }[Nς / false:}[NĂȂ)
	 */
	public boolean isMarked() {
		return marked;
	}
	/**
	 * ̃m[h̃}[N
	 */
	public void unmark() {
		marked = false;
	}
	/**
	 * ̃m[h}[Nς݂ɐݒ肷
	 */
	public void mark() {
		marked = true;
	}
	/**
	 * ̃m[hIς݂ǂԂ
	 * @return true:Iς / false:I
	 */
	public boolean isSelected() {
		return selected;
	}

	/**
	 * ̃m[h̑IԂݒ肷
	 * @param b true:Iς / false:I
	 */
	public void setSelected(boolean b) {
		selected = b;
	}
	/**
	 * 2_Ԃ̋v
	 * @param node rm[h
	 * @return ()
	 */
	public double distanceFrom(Node node) {
		double holizon = Math.abs(getX() - node.getX());
		double verical = Math.abs(getY() - node.getY());

		// m[hǂ̂炢NێĂ邩
		int links = 5 - node.getRelativeNodes().size();
		if(links < 0) {
			links = 0;
		}
		// pOp`̎Εӂ̒ = 2_Ԃ̋
		return (double)Math.sqrt(Math.pow(holizon, 2) + Math.pow(verical, 2)) + links * 100;
	}

	/**
	 * tH[JẌԂ
	 * @return tH[JX
	 */
	public Rectangle getSelectableRectangle() {
		Rectangle rect = getRectangle();
		rect.x -= OverlayNetworkConstant.NODE_CLICK_FORCUS_PIXEL /2;
		rect.y -= OverlayNetworkConstant.NODE_CLICK_FORCUS_PIXEL /2;
		rect.width += OverlayNetworkConstant.NODE_CLICK_FORCUS_PIXEL;
		rect.height += OverlayNetworkConstant.NODE_CLICK_FORCUS_PIXEL;
		
		return rect;
	}
	/**
	 * ʕ`p̃N^OԂ
	 * @return ʕ`p̃N^O
	 */
	public Rectangle getRectangle() {
		Rectangle rect = new Rectangle();
		rect.setBounds(
			(int)getX() - OverlayNetworkConstant.NODE_DRAW_WIDTH /2,
			(int)getY() - OverlayNetworkConstant.NODE_DRAW_HEIGHT /2,
			OverlayNetworkConstant.NODE_DRAW_WIDTH,
			OverlayNetworkConstant.NODE_DRAW_HEIGHT
		);
		return rect;
	}

	/**
	 * ̃m[hۗLĂ郊NSĕԂ
	 * @return ֘AÂĂm[h̃Xg
	 */
	public Iterator iteratorRelativeNodes() {
		return relativeNodes.iterator();
	}
	/**
	 * ̃m[hۗLĂ郊NSĕԂ
	 * @return Xg
	 */
	public List getRelativeNodes() {
		return relativeNodes;
	}
	/**
	 * œKm[hIs
	 * ̃\bhsƁCIĂ郋[eBOASYɏ]
	 * œKm[hIȂB̌ʂƂāC̃m[hё̊֘Am[hƂ̌
	 * ԂXVBꍇɂĂ͂AIɕϓB
	 */
	public void configure() {
		algorithm.configure();
	}
}
