/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: OverlayNetwork.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JWindow;

import org.logical_paradox.testsite.oln.object.AppContext;
import org.logical_paradox.testsite.oln.view.NetworkViewPanel;

/**
 * I[o[Clbg[NV~[^
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class OverlayNetwork {
	/**
	 * C\bh
	 * @param args 
	 */
	public static final void main(String[] args) throws Exception {
		int width = OverlayNetworkConstant.DEFAULT_WINDOW_WIDTH;
		int height = OverlayNetworkConstant.DEFAULT_WINDOW_HEIGHT;
		JFrame mainFrm = new JFrame();
		AppContext context = new AppContext();
		context.setFrame(mainFrm);
		mainFrm.getContentPane().add(NetworkViewPanel.init(context));

		mainFrm.setTitle(OverlayNetworkConstant.WINDOW_TITLE);

		JWindow wnd = new JWindow(mainFrm);
		mainFrm.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			}
		);

		Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
		mainFrm.setLocation(((int)windowLocation.getWidth() - width) /2, ((int)windowLocation.getHeight() - height) /2);
		mainFrm.setSize(new Dimension(width, height));
		mainFrm.setVisible(true);

		// EBhE̕\
		wnd.setEnabled(true);
		wnd.validate();
		wnd.setVisible(true);
		wnd.repaint();
		wnd.show();
	}
}
