/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

import java.util.ArrayList;

public class StringUtils {
    public static final String RANDOM_TEXT_SEED = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private StringUtils() {
    }

    public static final boolean isEmpty(String msg) {
        return msg == null || msg.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String msg) {
        return !StringUtils.isEmpty(msg);
    }

    public static final boolean isIntStr(String msg) {
        boolean rc = true;
        try {
            Integer.parseInt(msg);
        }
        catch (NumberFormatException ne) {
            rc = false;
        }
        return rc;
    }

    public static final boolean isLongStr(String msg) {
        boolean rc = true;
        try {
            Long.parseLong(msg);
        }
        catch (NumberFormatException ne) {
            rc = false;
        }
        return rc;
    }

    public static final String trimControlChars(String str) {
        StringBuffer sb = new StringBuffer();
        char[] characters = str.toCharArray();
        int i = 0;
        while (i < characters.length) {
            if (characters[i] >= ' ') {
                sb.append(characters[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static Integer[] searchWordIndexes(String text, String word) {
        ArrayList<Integer> locations = new ArrayList<Integer>();
        int bgn = 0;
        do {
            if ((bgn = text.indexOf(word, bgn)) < 0 || bgn >= text.length()) continue;
            locations.add(new Integer(bgn));
            ++bgn;
        } while (bgn >= 0);
        return locations.toArray(new Integer[0]);
    }

    public static final String randomText(int length, boolean fixed) {
        StringBuffer sb = new StringBuffer();
        if (!fixed) {
            length = (int)(Math.random() * 8.0) + 1;
        }
        int i = 0;
        while (i < length) {
            sb.append(RANDOM_TEXT_SEED.charAt((int)(Math.random() * (double)RANDOM_TEXT_SEED.length())));
            ++i;
        }
        return sb.toString();
    }
}

