/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import junit.framework.TestCase;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionManager;

public class SessionUnbounderTest
extends TestCase {
    public SessionUnbounderTest(String arg0) {
        super(arg0);
    }

    public void testDestroyAllSessions() throws InterruptedException, IllegalSessionStateException {
        int i;
        SessionManager man = new SessionManager(250, 1000L);
        Session[] sessions = new Session[12];
        for (i = 0; i < sessions.length; ++i) {
            sessions[i] = man.getSession();
        }
        Thread.sleep(2000L);
        for (i = 0; i < sessions.length; ++i) {
            SessionUnbounderTest.assertTrue((null == man.getSession(sessions[i].getSessionId(), false) ? 1 : 0) != 0);
            try {
                sessions[i].setAttribute("logical-paradox.org", "\u3042\u3042\u3042");
                SessionUnbounderTest.fail();
                continue;
            }
            catch (IllegalSessionStateException se) {
                // empty catch block
            }
        }
    }

    public void testDestroySessionsWithoutSomeOfThem() throws Exception {
        int i;
        SessionManager man = new SessionManager(100, 1500L);
        Session[] sessions = new Session[12];
        for (i = 0; i < sessions.length; ++i) {
            sessions[i] = man.getSession();
        }
        Thread.sleep(1000L);
        sessions[2].touch();
        sessions[9].touch();
        Thread.sleep(700L);
        for (i = 0; i < sessions.length; ++i) {
            if (i == 2 || i == 9) {
                SessionUnbounderTest.assertTrue((null != man.getSession(sessions[i].getSessionId(), false) ? 1 : 0) != 0);
                sessions[i].setAttribute("logical-paradox.org", "\u3042\u3042\u3042");
                continue;
            }
            SessionUnbounderTest.assertTrue((null == man.getSession(sessions[i].getSessionId(), false) ? 1 : 0) != 0);
            try {
                sessions[i].setAttribute("logical-paradox.org", "\u3042\u3042\u3042");
                SessionUnbounderTest.fail();
                continue;
            }
            catch (IllegalSessionStateException se) {
                // empty catch block
            }
        }
    }
}

