/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import junit.framework.TestCase;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionBindingListener;

public class SessionTest
extends TestCase {
    public SessionTest(String arg0) {
        super(arg0);
    }

    public void testSessionUnbound() throws IllegalSessionStateException {
        Session session = new Session("session-id");
        SessionBindingListenerImpl listener = new SessionBindingListenerImpl();
        session.setSessionBindingListener(listener);
        SessionTest.assertEquals((boolean)false, (boolean)listener.isDoSomething());
        session.unbound();
        SessionTest.assertEquals((boolean)true, (boolean)listener.isDoSomething());
    }

    public void testSessionUnboundWithoutEvent() throws IllegalSessionStateException {
        Session session = new Session("session-id");
        SessionBindingListenerImpl listener = new SessionBindingListenerImpl();
        session.setSessionBindingListener(listener);
        SessionTest.assertEquals((boolean)false, (boolean)listener.isDoSomething());
        session.removeSessionBindingListener();
        session.unbound();
        SessionTest.assertEquals((boolean)false, (boolean)listener.isDoSomething());
    }

    public void testSessionTimeout() throws InterruptedException, IllegalSessionStateException {
        Session session = new Session("sid", 1000L);
        Thread.sleep(5L);
        SessionTest.assertEquals((boolean)true, (boolean)session.isActive());
        Thread.sleep(1000L);
        SessionTest.assertEquals((boolean)false, (boolean)session.isActive());
        session.setAttribute("something", "something");
        SessionTest.assertEquals((boolean)true, (boolean)session.isActive());
    }

    class SessionBindingListenerImpl
    implements SessionBindingListener {
        private boolean doSomething = false;

        SessionBindingListenerImpl() {
        }

        public void onUnBound() {
            this.doSomething = true;
        }

        public boolean isDoSomething() {
            return this.doSomething;
        }
    }
}

