/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionManager;

public class SessionManagerTest
extends TestCase {
    public SessionManagerTest(String arg0) {
        super(arg0);
    }

    public void testCreateNewSession() throws IllegalSessionStateException {
        Session session;
        SessionManager manager = new SessionManager();
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (int i = 0; i < 100; ++i) {
            sessions.add(manager.getSession());
        }
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            session = (Session)it.next();
            SessionManagerTest.assertEquals((boolean)true, (boolean)manager.isExists(session.getSessionId()));
            manager.removeSession(session.getSessionId());
        }
        it = sessions.iterator();
        while (it.hasNext()) {
            session = (Session)it.next();
            SessionManagerTest.assertEquals((boolean)false, (boolean)manager.isExists(session.getSessionId()));
        }
    }

    public void testContinueSession() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg");
        SessionManagerTest.assertFalse((boolean)"abcdefg".equals(session.getSessionId()));
        Session newSession = manager.getSession(session.getSessionId());
        SessionManagerTest.assertNotNull((Object)newSession);
        SessionManagerTest.assertTrue((newSession == session ? 1 : 0) != 0);
    }

    public void testContinueSessionWithCreate() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg", true);
        SessionManagerTest.assertNotNull((Object)session);
    }

    public void testContinueSessionWithoutCreate() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg", false);
        SessionManagerTest.assertNull((Object)session);
    }
}

