/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.logical_paradox.common.io.ByteStream;

public class ExpandableBuffer
implements ByteStream {
    public static final int DEFAULT_BLOCKSIZE = 4096;
    protected byte[] _buffer;
    protected final int _blocksize;
    protected int _eob;
    protected int _seekp;

    public ExpandableBuffer() {
        this(4096);
    }

    public ExpandableBuffer(int blocksize) {
        this._blocksize = blocksize;
        this._buffer = new byte[blocksize];
        this._eob = 0;
    }

    public int size() {
        return this._buffer.length;
    }

    public void seek(int seekp) throws IOException {
        this._seekp = seekp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        ExpandableBuffer expandableBuffer = this;
        synchronized (expandableBuffer) {
            if (this._seekp >= this._eob) {
                return -1;
            }
            int b = this._buffer[this._seekp++] & 0xFF;
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int i) throws IOException {
        ExpandableBuffer expandableBuffer = this;
        synchronized (expandableBuffer) {
            if (this._seekp >= this.size()) {
                this.expand();
            }
            this._buffer[this._seekp++] = (byte)(i & 0xFF);
            if (this._seekp > this._eob) {
                this._eob = this._seekp;
            }
        }
    }

    public void write(byte b) throws IOException {
        this.write((int)b);
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    public int using() {
        return this._eob;
    }

    public InputStream getInputStream() {
        return new ExpBufferInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new ExpBufferOutputStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expand() {
        ExpandableBuffer expandableBuffer = this;
        synchronized (expandableBuffer) {
            int buffersize = this.size();
            byte[] newBuffer = new byte[buffersize + this._blocksize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, buffersize);
            this._buffer = newBuffer;
        }
    }

    public byte[] byteStream() {
        byte[] buffer = new byte[this._eob];
        System.arraycopy(this._buffer, 0, buffer, 0, this._eob);
        return buffer;
    }

    protected class ExpBufferOutputStream
    extends OutputStream {
        protected ExpandableBuffer _buffer;

        protected ExpBufferOutputStream(ExpandableBuffer buffer) {
            this._buffer = buffer;
        }

        public void write(int b) throws IOException {
            this._buffer.write(b);
        }
    }

    protected class ExpBufferInputStream
    extends InputStream {
        protected ExpandableBuffer _buffer;

        protected ExpBufferInputStream(ExpandableBuffer buffer) {
            this._buffer = buffer;
        }

        public int read() throws IOException {
            return this._buffer.read();
        }
    }
}

