/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import junit.framework.TestCase;

/**
 * BtreePage̒P̃eXgjbg<br>
 * @author satoshi akabane
 * @version 1.0
 */
public class BtreePageTest extends TestCase {
	private BtreeFactory _factory = null;

	public BtreePageTest( String name ) {
		super(name);
	}

	/**
	 * RXgN^(1)̃eXg
	 */
	public void testBtreePage_Constructor1() throws Exception {
		BtreePage bp = null;

		/*
		 * n
		 */
		_factory.getProperty().setProperty(BtreeFile.ORDER, "64");
		bp = new BtreePage(_factory,1);
		assertTrue("n̎", bp.order() == 64);
		assertTrue("ñy[Wԍ", bp.getPageNo() == 1);
		assertTrue("n̎qm[h", bp.children() == 65);

		/*
	 	 * 0ȉɂꍇ
	 	 */
		try {
			_factory.getProperty().setProperty(BtreeFile.ORDER, "0");
			bp = new BtreePage(_factory,0);
			fail("0ō쐬Ă܂");
		} catch( BtreeException be1 ) {
		}
		try {
			_factory.getProperty().setProperty(BtreeFile.ORDER, "-1");
			bp = new BtreePage(_factory,0);
			fail("-1ō쐬Ă܂");
		} catch( BtreeException be2 ) {
		}

		/*
		 * y[Wԍ0ɂꍇ
		 */
		try {
			_factory.getProperty().setProperty(BtreeFile.ORDER, "1");
			bp = new BtreePage(_factory,-1);
			fail("y[Wԍ-1ō쐬Ă܂");
		} catch( BtreeException be3 ) {
		}

		// ŌɃy[Wԍ0ŃeXg - lƂĂ͖Ȃ
		_factory.getProperty().setProperty(BtreeFile.ORDER, "1");
		bp = new BtreePage(_factory,0);
	}
	/**
	 * RXgN^(2)̃eXg
	 */
	public void testBtreePage_Constructor2() {
	}
	/**
	 * L[}̃eXg
	 * eL[͊i[邵CiP[XɂĂ͊i[Ȃ
	 */
	public void testInsert() throws Exception {
		_factory.getProperty().setProperty(BtreeFile.ORDER, "3");
		BtreePage bp = new BtreePage(_factory, 0);
		BtreeKey[] keys = new BtreeKey[4];
		keys[0] = new BtreeKeyTestImpl("L[1");
		keys[1] = new BtreeKeyTestImpl("L[2");
		keys[2] = new BtreeKeyTestImpl("L[3");
		keys[3] = new BtreeKeyTestImpl("L[4");

		for(int i = 0; i < 4; i++) {
			BtreePage.PromoResult pr = bp.insert(keys[i], -1);
			assertTrue("Ȃi: i=" + i, pr == null || i == 3);
			assertTrue("L[̑: k="+ bp.keyCount(), (bp.keyCount() == i+1 && i < 3 || bp.keyCount() == 2 && i == 3));
			assertTrue("}͂Ȃ̂Ƀy[WɊi[ĂȂ", (bp.isContained(keys[i]) == true && i < 3) || (bp.isContained(keys[i]) == false && i == 3));
			if(i == 3) {
				assertTrue("iȂ", pr != null && pr._promoKey != null);
				assertTrue("Ȃ", pr != null && pr._page != null);
			}
		}
	}
	/**
	 * ĩeXg
	 */
	public void testPromotion() throws Exception {
		_factory.getProperty().setProperty(BtreeFile.ORDER, "3");
		BtreePage bp = new BtreePage(_factory, 0);
		BtreePage.PromoResult pr = null;

		BtreeKey key1 = new BtreeKeyTestImpl("A");
		pr = bp.insert(key1,-1);
		assertTrue("Ȃi - A", pr == null);

		BtreeKey key2 = new BtreeKeyTestImpl("G");
		pr = bp.insert(key2,1);
		assertTrue("Ȃi - G", pr == null);

		BtreeKey key3 = new BtreeKeyTestImpl("M");
		pr = bp.insert(key3,3);
		assertTrue("Ȃi - M", pr == null);

		BtreeKey key4 = new BtreeKeyTestImpl("Q");
		pr = bp.insert(key4,-1);

		assertTrue("iȂ - Q", pr != null);
		assertTrue("îMłȂ", pr._promoKey.equals(new BtreeKeyTestImpl("M")) );
		assertTrue("îG", !pr._promoKey.equals(new BtreeKeyTestImpl("G")) );
		assertTrue("îQ", !pr._promoKey.equals(new BtreeKeyTestImpl("Q")) );
		assertTrue("îA", !pr._promoKey.equals(new BtreeKeyTestImpl("A")) );

		assertTrue("ɂĔy[WɊi[ĂL[̐1łȂ:"+pr._page.keyCount(), pr._page.keyCount() == 1);
		assertTrue("ɂĔy[WA܂܂Ă", !pr._page.isContained(key1));
		assertTrue("ɂĔy[WG܂܂Ă", !pr._page.isContained(key2));
		assertTrue("ɂĔy[WM܂܂Ă", !pr._page.isContained(key3));
		assertTrue("ɂĔy[WQ܂܂ĂȂ", pr._page.isContained(key4));

		assertTrue("A̍̎q-1łȂ", bp.leftChildOf(key1) == -1);
		assertTrue("ẢE̎q-1łȂ", bp.rightChildOf(key1) == -1);
		assertTrue("G̍̎q-1łȂ", bp.leftChildOf(key2) == -1);
		assertTrue("G̉E̎q1łȂ", bp.rightChildOf(key2) == 1);
		assertTrue("Q̍̎q3łȂ", pr._page.leftChildOf(key4) == 3);
		assertTrue("Q̉E̎q-1łȂ", pr._page.rightChildOf(key4) == -1);
	}
	/**
	 * L[̃eXg
	 */
	public void testFind() throws Exception {
		_factory.getProperty().setProperty(BtreeFile.ORDER, "5");
		BtreePage bp = new BtreePage(_factory, 0);
		BtreeKeyTestImpl key = new BtreeKeyTestImpl("eXgL[");
		BtreePage.PromoResult pr = bp.insert(key, -1);

		assertTrue("y[W猩Ȃ", bp.find(key.toString()) != null);
	}
	/**
	 * wL[y[WɊ܂܂ׂǂ̌eXg
	 */
	public void testShouldBeContained() throws Exception {
		_factory.getProperty().setProperty(BtreeFile.ORDER, "7");
		BtreePage bp = new BtreePage(_factory, 0);
		BtreeKeyTestImpl key1 = new BtreeKeyTestImpl("A");
		BtreeKeyTestImpl key2 = new BtreeKeyTestImpl("D");
		BtreeKeyTestImpl key3 = new BtreeKeyTestImpl("B");
		BtreePage.PromoResult pr = null;
		pr = bp.insert(key1, -1);
		pr = bp.insert(key2, -1);

		assertTrue("܂܂ׂ͂Ȃ̂Ɋ܂܂ȂƂł", bp.shouldBeContained(key3) == true);

		pr = bp.insert(key3, 0);		// BE̎qwő}D C͑}łȂ͂
		BtreeKeyTestImpl key4 = new BtreeKeyTestImpl("C");
//		try {
//			bp.insert(key4,5);
//			fail("}łȂ͂C}łĂ܂");
//		} catch(BtreeManipulationException be) {
//			// }łȂ͂Ȃ̂ŁCɏʂΐn
//		}

		// ԍɊi[eXg
		BtreeKeyTestImpl key5 = new BtreeKeyTestImpl("0");
		bp.insert(key5, 1);

		// ԉEɊi[eXg
		BtreeKeyTestImpl key6 = new BtreeKeyTestImpl("Q");
		bp.insert(key6,-1);
	}
	/**
	 * L[y[WɊi[Ă邩ǂ̔eXg
	 */
	public void testIsContained() throws Exception {
		BtreeKeyTestImpl key2 = new BtreeKeyTestImpl("ɂ");
		BtreeKeyTestImpl key1 = new BtreeKeyTestImpl("abc");
		_factory.getProperty().setProperty(BtreeFile.ORDER, "16");
		BtreePage bp = new BtreePage(_factory, 0);
		bp.insert(key2, -1);
		bp.insert(key1, -1);
		assertNotNull(bp.find("abc"));
		assertNotNull(bp.find("ɂ"));
	}
	/**
	 * y[WŜoCgXg[ɕϊeXg
	 * @throws Exception
	 */
	public void testToByteStream() throws Exception {
		BtreeFile file = _factory.getFileHandle("aa");
		// ̐ݒɖ߂
		_factory.getProperty().setProperty(BtreeFile.ORDER, "64");
		BtreePage btp = file.newPage();

		int keyByteSize = 128;
		int _order = 64;
		int pageStreamSize = keyByteSize * _order + 8 * (_order+1) +4;

		assertEquals(64,Integer.parseInt(_factory.getProperty().getProperty(BtreeFile.ORDER)));
		assertEquals(keyByteSize, _factory.keyByteSize());
		assertEquals(_order, btp.order());
		assertEquals(pageStreamSize, btp.getByteStream().length);
	}
	/**
	 * oCgXg[y[WŜ𕜌eXg
	 * @throws Exception
	 */
	public void testFromByteStream() throws Exception {
		BtreeFile file = _factory.getFileHandle("aa");
		// ̐ݒɖ߂
		_factory.getProperty().setProperty(BtreeFile.ORDER, "64");
		BtreePage btp1 = file.newPage();
		btp1.insert(_factory.newKey(""), 1024);
		BtreePage btp2 = new BtreePage(_factory, 100, btp1.getByteStream());
		
		assertEquals(btp1.order(), btp2.order());
		assertEquals(btp1.keyCount(), btp2.keyCount());
		assertNotNull(btp1.find(""));
		assertNotNull(btp2.find(""));
		assertEquals(btp1.find(""), btp2.find(""));

		assertEquals(btp1.rightChildOf(btp1.find("")), btp2.rightChildOf(btp2.find("")));
		assertEquals(btp1.leftChildOf(btp1.find("")), btp2.leftChildOf(btp2.find("")));
	}
	/**
	 * L[폜̃eXg
	 */
	public void testDelete() {
	}
	
	/**
	 * eXg̏
	 */
	public void setUp() throws Exception {
		_factory = BtreeFactory.getInstance("org.logical_paradox.common.btree.BtreeFactoryTestImpl");
	}
}

// end of BtreePageTest.java
