/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

/**
 * BtreeKeỹeXgp̎<br>
 * ݂̂ɂPȎD
 * @author satoshi akabane
 * @version 1.0
 */
public class BtreeKeyTestImpl extends BtreeKey {
	private String _key;

	/**
	 * RXgN^
	 *
	 * @param o L[
	 */
	public BtreeKeyTestImpl(Object o) throws BtreeException {
		super(o);
	}

	/**
	 * RXgN^
	 *
	 * @param bstream oCg
	 * @exception BtreeException oCg񂩂L[𕜌łȂꍇɔ
	 */
	public BtreeKeyTestImpl(byte[] bstream) throws BtreeException {
		super(bstream);
	}

	/**
	 * IuWFNgBtreeKey̎̂𐶐D<br>
	 * ̃\bh͌JȂDʏ<br>
	 * public void objectToBtreeKey(String str)<br>
	 * ̂قgp
	 * @param o IuWFNg
	 * @throws BtreeException ̉Ɏs
	 */
	protected void objectToBtreeKey(Object o) throws BtreeException {
		if(o instanceof java.lang.String == false) {
			throw new BtreeException("IuWFNgjava.lang.StrinĝݗLł");
		}
		_key = (String)o;
	}
	/**
	 * IuWFNgBtreeKey̎̂𐶐D
	 * @param o IuWFNg
	 * @throws BtreeException ̉Ɏs
	 */
	public void objectToBtreeKey(String str) throws BtreeException {
		if(str == null) {
			throw new BtreeException("IuWFNgnullł");
		}
		objectToBtreeKey((Object)str);
	}
	/**
	 * oCg񂩂BtreeKey̎̂𐶐D
	 * @param bstream oCg
	 * @exception BtreeException
	 */
	public void byteStreamToBtreeKey( byte[] bstream ) throws BtreeException {
		_key = new String(bstream).trim();
	}

	/**
	 * L[̕`ԂD
	 * @return String L[̕`
	 */
	public String toString() {
		return _key;
	}

	/**
	 * L[rD
	 * @param obj rΏ
	 * @return boolean true: ł / false: Ⴄ
	 */
	public boolean equals( Object obj ) {
		return _key.equals(obj.toString());
	}

	/**
	 * w肳ꂽL[菬ǂԂ
	 * @param key rΏ
	 * @return boolean true: this < key / false: this >= key
	 */
	public boolean isLessThan( BtreeKey key ) {
		return _key.compareTo(key.toString()) < 0;
	}

	/**
	 * w肳ꂽL[傫ǂԂ
	 * @param key rΏ
	 * @return boolean true: this > key / false: this <= key
	 */
	public boolean isGreaterThan( BtreeKey key ) {
		return _key.compareTo(key.toString()) > 0;
	}

	/**
	 * L[̃oCgXg[ԂD<br>
	 * iXg[Wɑ΂ăL[ۑۂɁCBtreePageɂ
	 * ĂяoD<br>
	 * L[͌Œ蒷TCYŁCȏ̒̃L[͎IɃTCYɐ`D
	 * @return byte[] oCg
	 */
	public byte[] byteStream() {
		byte[] result = new byte[byteSize()];
		byte[] bstream = _key.getBytes();
		System.arraycopy(bstream, 0, result, 0, bstream.length);

		return result;
	}

	/**
	 * oCgXg[ɂۂ̃TCY<br>
	 * L[̑傫͌Œ蒷Ȃ̂ŁCKŒTCYԂ
	 * @return int oCg\ɂꍇ̃TCY
	 */
	public int byteSize() {
		return 128;
	}
}

// end of BtreeKeyTestImpl.java
