/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.util.Properties;

import org.logical_paradox.common.io.MemoryMappedRandomAccessFile;
import org.logical_paradox.common.io.RandomAccessFileDelegator;

import junit.framework.TestCase;

/**
 * BtreeFilẽeXg
 * @author satoshi akabane
 * @version 1.0
 */
public class BtreeFileTest extends TestCase {
	private static final int ORDER = 32;
	private BtreeFactory _factory;

	// vpeBw̃RXgN^̃eXg
	public void testSetProperty() throws Exception {
		// 킴ƗO₷悤ȃR[fBOɂĂ(check̈)
		Properties prop = new Properties();

		// vpeBK{ڎwȂ̏ꍇ͗O
		try {
			BtreeFile btf1 = new BtreeFileMoc(_factory, prop);
			fail("vpeB̓es\Ȃ̂ɗOȂ");
		} catch(BtreeException e1) {
		}

		// Kv\ڂ܂Ăꍇ͗O͔Ȃ
		prop.setProperty(BtreeFile.FILENAME, "btree.idx");
		prop.setProperty(BtreeFile.MAGIC_NUMBER, "ABCD");

		prop.setProperty(BtreeFile.MAJOR_VERSION, "100");
		prop.setProperty(BtreeFile.MINOR_VERSION, "200");
		prop.setProperty(BtreeFile.HEADER_SIZE, "256");
		prop.setProperty(BtreeFile.ORDER, "64");
		prop.setProperty(BtreeFile.KEYSIZE, "32");

		try {
			BtreeFile btf2 = new BtreeFileMoc(_factory, prop);
		} catch(BtreeException e2) {
			fail("vpeB̓e\Ȃ̂ɗO1");
		}

		// Sw̏ꍇO͔Ȃ
		prop.setProperty(BtreeFile.ROOT_PAGE, "100");
		prop.setProperty(BtreeFile.MAX_ASSIGNED_PAGE, "500");
		try {
			BtreeFile btf3 = new BtreeFileMoc(_factory, prop);
		} catch(BtreeException e3) {
			fail("vpeB̓e\Ȃ̂ɗO2");
		}

	}
	// wb_ubN̏oeXg
	public void testflush() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		BtreeFile btf2 = _factory.getFileHandle("1");

		// _ANZXt@C̃CX^XV쐬ăZbg
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
		btf1._btfile = file;

		byte[] magicno = new byte[4];
		magicno[0] = (byte)'B';
		magicno[1] = (byte)'Y';
		magicno[2] = (byte)'T';
		magicno[3] = (byte)'E';
		btf1.setMagicNumber(magicno);
		btf1.setVersion(5,2);

		// 
		btf1.flush();
		file.seek(0);

		// btf1ŏ񂾃t@C̃CX^Xbtf2փZbg
		btf2._btfile = file;
		// [h
		btf2.reload();

		assertEquals("}WbNio[̃Zbgɖ肪", "BYTE", btf2.getMagicNumber());
		assertEquals("W[o[W̃Zbgɖ肪", 5, btf2.getMajorVersion());
		assertEquals("}Ci[o[W̃Zbgɖ肪", 2, btf2.getMinorVersion());
	}
	// }WbNio[̐ݒeXg
	public void testSetMagicNumber() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");

		byte[] magicno = new byte[4];
		magicno[0] = (byte)'B';
		magicno[1] = (byte)'Y';
		magicno[2] = (byte)'T';
		magicno[3] = (byte)'E';

		// n
		btf1.setMagicNumber(magicno);

		// 0ł
		byte[] magicno4 = new byte[0];
		try {
			btf1.setMagicNumber(magicno4);
			fail("oCgz0Ȃ̂ɗOȂ");
		} catch(IllegalArgumentException i3) {
		}
		// Ȃ
		byte[] magicno2 = new byte[3];
		try {
			btf1.setMagicNumber(magicno2);
			fail("oCgz񂪏Ȃ̂ɗOȂ");
		} catch(IllegalArgumentException i1) {
		}

		// 
		byte[] magicno3 = new byte[5];
		try  {
			btf1.setMagicNumber(magicno3);
			fail("oCgz񂪑̂ɗOȂ");
		} catch(IllegalArgumentException i2) {
		}
	}
	// [gy[Wԍ̕ύXeXg
	public void testReplaceRootPageNo() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		BtreeFile btf2 = _factory.getFileHandle("1");

		// _ANZXt@C̃CX^XV쐬ăZbg
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
		btf1._btfile = file;

		// [gy[Wԍݒ肵ăR~bg
		btf1.replaceRootPageNo(12393);
		btf1.flush();

		// ʂBtreeFilẽCX^Xł̃t@CǂݎĔr
		btf2._btfile = file;
		btf2.reload();

		assertEquals("[gy[WԍǂݏłȂ", 12393, btf2.getRootPageNo());
	}
	// wb_ubÑTCYWlłȂꍇ̃tbṼeXg
	public void testFlush() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		btf1._btfile = new MemoryMappedRandomAccessFile();
		btf1._sizeOfHeader = 256;
		btf1.flush();
	}
	// VKy[W쐬̃eXg
	public void testNewPage() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		BtreeFile btf2 = _factory.getFileHandle("1");

		// _ANZXt@C̃CX^XV쐬ăZbg
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
		btf1._btfile = file;

		btf1._maxAssignedPageNo = 0;
		BtreePage btp = btf1.newPage();
		btf1.flush();
		assertEquals("őy[WԍXVȂ", 1, btf1.getMaxAssignedPageNo());
		assertNotNull("y[W쐬Ȃ", btp);

		// btf2Ńt@C[h
		btf2._btfile = file;
		btf2.reload();
		assertEquals("t@C̍őy[WXVĂȂ", 1, btf2.getMaxAssignedPageNo());
	}
	// w肳ꂽԍ̃y[W擾eXg
	public void testGetPage() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		// _ANZXt@C̃CX^XV쐬ăZbg
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
//		RandomAccessFileDelegator file = new CommonRandomAccessFileDelegator("a.out", "rw");

		btf1._btfile = file;

		// Vy[W쐬ăL[}
		BtreePage btp1 = btf1.newPage();
		btp1.insert(_factory.newKey(""), 102);
		btp1.insert(_factory.newKey(""), -1);
		btf1.replacePage(btp1);
		btf1.flush();

		BtreePage btp2 = btf1.getPage(btp1.getPageNo());

		// _v̏o
		/*
		CharacterEncoder encoder = new HexDumpEncoder();
		encoder.encode(btp2.getByteStream(), System.out);
		*/

		assertEquals(btp1.getPageNo(), btp2.getPageNo());
		assertEquals(btp2.find(""), _factory.newKey(""));
		assertEquals(btp2.find(""), _factory.newKey(""));
		assertEquals(-1,btp2.leftChildOf(_factory.newKey("")));
		assertEquals(102,btp2.rightChildOf(_factory.newKey("")));
		assertEquals(102,btp2.leftChildOf(_factory.newKey("")));
		assertEquals(-1,btp2.rightChildOf(_factory.newKey("")));
	}
	// y[W̃eXg
	public void testDisablePage() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
		btf1._btfile = file;

		// Vy[Wǉ
		BtreePage btp1 = btf1.newPage();
		btp1.insert(_factory.newKey(""), 102);
		btp1.insert(_factory.newKey(""), -1);
		btf1.replacePage(btp1);
		btf1.flush();

		// y[W𖳌
		long pagenoOfBtp1 = btp1.getPageNo();
		btp1.setEnabled(false);
		btf1.replacePage(btp1);

		// y[W𕜌Ĕr
		BtreePage btp2 = btf1.getPage(pagenoOfBtp1);
		assertEquals(false, btp2.isEnabled());
	}
	// y[W̍ėp̃eXg
	public void testRecycleDisabledPage() throws Exception {
		BtreeFile btf1 = _factory.getFileHandle("1");
		RandomAccessFileDelegator file = new MemoryMappedRandomAccessFile();
		btf1._btfile = file;

		//Vy[Wǉ
		BtreePage btp1 = btf1.newPage();
		btp1.insert(_factory.newKey(""), 102);
		btp1.insert(_factory.newKey(""), -1);
		btf1.replacePage(btp1);
		btf1.flush();
		long pagenoOfBtp1 = btp1.getPageNo();

		// y[W𖳌鏈
		btp1.setEnabled(false);
		btf1.replacePage(btp1);
		btf1.flush();

		// Vy[Wǉ
		BtreePage btp2 = btf1.newPage();

		// y[Wԍ̍ėpmF
		assertEquals(true, btp2.isEnabled());
		assertEquals(pagenoOfBtp1, btp2.getPageNo());
		// 폜ꂽy[W̃y[Wԍ-1ɂȂĂ邱ƂmF
		assertEquals(-1,btp1.getPageNo());
	}
	// ZbgAbv
	public void setUp() throws Exception {
		_factory = BtreeFactory.getInstance("org.logical_paradox.common.btree.BtreeFactoryTestImpl");
	}
}
