package org.logical_paradox.common.btree;

import java.util.Properties;

/**
 * BtreeFactorỹeXgp̎<br>
 * BtreeKeyTestImplBtreeObjectTestImplԂ
 * @author satoshi akabane
 */
public class BtreeFactoryTestImpl extends BtreeFactory {
	private static BtreeKey _key = null;
	protected static Properties _prop = null;

	static {
		// ̃t@NgŐL[CIuWFNgуt@C̐ݒl̏
		_prop = new Properties();
		_prop.setProperty(BtreeFile.MAGIC_NUMBER, "ABCD");
		_prop.setProperty(BtreeFile.MAJOR_VERSION, "100");
		_prop.setProperty(BtreeFile.MINOR_VERSION, "200");
		_prop.setProperty(BtreeFile.HEADER_SIZE, "256");
		_prop.setProperty(BtreeFile.ORDER, "16");
		_prop.setProperty(BtreeFile.KEYSIZE, "128");
	}

	/**
	 * ̃t@NgŐt@C̐ݒlԂ
	 * 
	 * @return ݒl
	 * @throws BtreeException ݒlԂƂłȂꍇ
	 */
	public Properties getProperty() throws BtreeException {
		return _prop;
	}

	/**
	 * VBtreeKeyԂ
	 *
	 * @param o L[̈
	 * @return BtreeKey L[
	 * @exception BtreeException L[̐Ɏs
	 * @see org.logical_paradox.common.btree.BtreeKey
	 */
	public BtreeKey newKey(Object o) throws BtreeException {
		return new BtreeKeyTestImpl(o);
	}

	/**
	 * oCg񂩂BtreeKey𕜌ĕԂ
	 * @param stream oCg
	 * @return ꂽL[
	 * @exception Ɏs
	 */
	public BtreeKey newKey(byte[] stream) throws BtreeException {
		return new BtreeKeyTestImpl(stream);
	}

	/**
	 * BtreeKeỹoCgTCYԂ
	 *
	 * @return int oCgTCY
	 * @see org.logical_paradox.common.btree.BtreeKey
	 */
	public int keyByteSize() {
		// TCYvp̃CX^X܂ĂȂꍇC
		if(_key == null) {
			try {
				_key = new BtreeKeyTestImpl("1");
			} catch(BtreeException e) {
				e.printStackTrace();
			}
		}
		return _key.byteSize();
	}

	/**
	 * t@CnhԂ<br>
	 * ̃\bhĂяoĂCt@Ĉ̓I[vĂȂƂɒ
	 * 
	 * @param filename t@C
	 * @return BtreeFile t@C
	 * @throws BtreeException 炩̗RŃt@Cnh̐Ɏs
	 */
	public BtreeFile getFileHandle(String filename) throws BtreeException {
		Properties prop = (Properties)getProperty().clone();
		prop.setProperty(BtreeFile.FILENAME, filename);

		return new BtreeFileMoc(this, prop);
	}

	/**
	 * p\XgԂ
	 * C쐬ꂽp\Xg̓I[vȂ
	 * @param filename t@C
	 * @return p\Xg
	 * @throws BtreeException p\Xg̍쐬Ɏs
	 */
	public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
		return new OnMemoryBtreeFragmentFile();
	}
}
