/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.logical_paradox.common.io.MemoryMappedRandomAccessFile;

/**
 * ŊǗBtreeFragmentFile
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class OnMemoryBtreeFragmentFile extends BtreeAvailableList {
	private MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();

	/**
	 * ftHgRXgN^
	 *
	 */
	public OnMemoryBtreeFragmentFile() {
		this("");
	}
	/**
	 * RXgN^
	 * fЉ𖳐ɕێ
	 */
	public OnMemoryBtreeFragmentFile(String filename) {
		this(filename, 0);
	}
	/**
	 * RXgN^
	 * w肳ꂽLbVTCY܂łfЉێȂ<br>
	 * cachesize0w肵ꍇCɕێ
	 * @param size LbVTCY(LbVR[h)
	 */
	public OnMemoryBtreeFragmentFile(String filename, int size) {
		super(filename, size);
	}

	/**
	 * fЉt@C̃t@CTCYԂ
	 * @return t@CTCY
	 * @throws IOException fЉt@CɃANZXłȂ
	 */
	protected long getFileSize() throws IOException {
		if(file == null) {
			file = new MemoryMappedRandomAccessFile();
		}
		return file.length();
	}

	/**
	 * t@CANZXɕKvȓ̓Xg[Ԃ
	 * Kt@C̐擪|CgĂ
	 * @return ̓Xg[
	 * @throws IOException I[vɎs
	 */	
	protected InputStream getInputStream() throws IOException {
		file.seek(0);
		return file.getInputStream();
	}

	/**
	 * t@CANZXɕKvȏo̓Xg[Ԃ
	 * Kt@C̐擪|CgĂD܂C̃\bhĂԂƊ̃t@C͔jD
	 * @return o̓Xg[
	 * @throws IOException I[vɎs
	 */
	protected OutputStream getOutputStream() throws IOException {
		file = new MemoryMappedRandomAccessFile();
		return file.getOutputStream();
	}

}
