/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

/**
 * B-treef[^\𑀍삷邽߂̃ZbVIuWFNg<br>
 * AvP[V͒BtreeNX𑀍삷̂ł͂ȂC̃ZbV}Ƃđ삷
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class BtreeSession {
	private final Btree _master;
	protected BtreeSession(Btree master) {
		_master = master;
	}
	/**
	 * ZbVJn
	 * @param filename t@C
	 * @return JnꂽZbV
	 * @throws BtreeException ZbV̊JnɎs
	 */
	public BtreeSession open(String filename) throws BtreeException {
		_master.open(filename);
		return this;
	}
	/**
	 * ZbVJn
	 * @param filename t@C
	 * @param cachesize LbVTCY
	 * @return JnꂽZbV
	 * @throws BtreeException ZbV̊JnɎs
	 */
	public BtreeSession open(String filename, int cachesize) throws BtreeException {
		_master.open(filename, cachesize);
		return this;
	}
	/**
	 * ZbV
	 * @throws BtreeException N[Yɉ炩̃G[ꍇ
	 */
	public void close() throws BtreeException {
		_master.close();
	}
	/**
	 * ZbVĂ邩ǂԂ
	 * @return true:Ă / false:JĂ
	 */
	public boolean isClosed() {
		return _master.isClosed();
	}
	/**
	 * w肳ꂽy[Wt@C擾ĕԂ
	 * @param pageno 擾Ώۃy[W(-1: [g)
	 * @return y[W
	 */
	public BtreePage getPage(long pageno) throws BtreeException {
		return _master.getPage(pageno);
	}
	/**
	 * [g̃y[W擾ĕԂ
	 * @return y[W
	 */
	public BtreePage getPage() throws BtreeException {
		return _master.getPage(-1);
	}
	/**
	 * VL[𔭍s
	 * @param o IuWFNg
	 * @return ꂽL[
	 */
	public BtreeKey newKey(Object o) throws BtreeException {
		return _master.newKey(o);
	}
	/**
	 * f[^}
	 *
	 * @param key L[
	 * @param o IuWFNg
	 * @exception BtreeException
	 */
	public void insert(BtreeKey key) throws BtreeException, BtreeManipulationException {
		_master.insert(key);
	}
	/**
	 * f[^폜
	 *
	 * @param key L[
	 */
	public void delete( BtreeKey key ) throws BtreeException {
		_master.delete(key);
	}

	/**
	 * f[^XV
	 *
	 * @param o IuWFNg
	 * @exception BtreeException
	 */
	public void update(BtreeKey key) throws BtreeException {
		_master.update(key);
	}

	/**
	 * f[^ƃL[̃yA擾
	 *
	 * @param key L[
	 * @return BtreeResultSet ʃZbg
	 * @exception BtreeException
	 */
	public BtreeResultSet find( BtreeKey key ) throws BtreeException {
		return _master.find(key);
	}
}
