/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * B-treẽy[W1ǗD<br>
 * 1y[Wɂ͕̃L[܂܂D<br>
 * ̃NX̓pbP[WO璼ڌĂяoăCX^X쐬邱Ƃ͂łȂD<br>
 * y[W𐶐邽߂ɂ́CBtreeNXnewPage()gpD<br>
 * @author satoshi akabane
 * @version 1.0
 */
public class BtreePage {
	public static final long NEW_PAGE = -1;				// Vy[WԍIɊUꍇ͂w

	private final int _order;							// 
	private long _pageno;									// y[Wԍ
	private BtreeKey[] _keys;								// L[
	private long[] _children;								// qm[hւ̃N(y[Wԍ)
	private int _keyCount;								// i[ĂL[̐

	private final BtreeKey[] _tempForPromoKey;			// iȂǂŎgpe|̈(L[)
	private final long[] _tempForPromoPtr;				// iȂǂŎgpe|̈(m[h֌W)
	private final BtreeFactory _factory;					// Btreet@Ng

	private boolean enabled = true;						// ̃y[WLǂ(true: L / false:)

	/**
	 * RXgN^<br>
	 * BtreePageĂяo邱Ƃz肵ĂCL[̔zqm[hւ̃NɃRs[łD<br>
	 * w肳ꂽL[̔z̃TCY = i[ĂL[̌ăJEg
	 *
	 * @param factory t@Ng
	 * @param pageno y[Wԍ
	 * @param keys L[
	 * @param children qm[hւ̃N
	 */
	protected BtreePage(BtreeFactory factory, long pageno, BtreeKey[] keys, long[] children) throws BtreeException {
		_factory = factory;
		int order = Integer.parseInt(factory.getProperty().getProperty(BtreeFile.ORDER));

		if( order <= 0 || pageno < 0 ) {
			throw new BtreeException("܂̓y[Wԍsł");
		}

		_order = order;
		_pageno = pageno;
		_keys = new BtreeKey[ order ];
		_children = new long[ order +1 ];			// qm[hւ̃N̓L[̐+1쐬
		_keyCount = 0;
		init();

		_tempForPromoKey = new BtreeKey[order+1];
		_tempForPromoPtr = new long[order+1+1];

		// Ŏw肳ꂽL[ƃÑRs[
		System.arraycopy( keys, 0, _keys, 0, keys.length );
		System.arraycopy( children, 0, _children, 0, children.length );
		_keyCount = keys.length;				// L[JEg̍Đݒ

		cleanTemp();
	}

	/**
 	 * RXgN^<br>
	 * pbP[WO璼ڌĂяoƂ͂łȂ<br>
	 *
	 * @param factory t@Ng
	 * @param pageno y[Wԍ
 	 */
	BtreePage(BtreeFactory factory, long pageno) throws BtreeException {
		_factory = factory;
		int order = Integer.parseInt(factory.getProperty().getProperty(BtreeFile.ORDER));
		if( order <= 0 || pageno < 0 ) {
			throw new BtreeException("܂̓y[Wԍsł");
		}

		_order = order;
		_pageno = pageno;
		_keys = new BtreeKey[ order ];
		_children = new long[ order +1 ];			// qm[hւ̃N̓L[̐+1쐬
		_keyCount = 0;

		_tempForPromoKey = new BtreeKey[order+1];
		_tempForPromoPtr = new long[order+1+1];

		init();
		cleanTemp();
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽoCg񂩂y[WŜ𕜌^Cv
	 *
	 * @param factory t@Ng
	 * @param pageno y[Wԍ
	 * @param page y[W̃oCg
	 * @exception BtreeException w肳ꂽoCg񂩂y[WłȂꍇ
	 */
	BtreePage(BtreeFactory factory, long pageno, byte[] page) throws BtreeException {
		_factory = factory;
		int order = Integer.parseInt(factory.getProperty().getProperty(BtreeFile.ORDER));
		if( order <= 0 || pageno < 0 ) {
			throw new BtreeException("܂̓y[Wԍsł");
		}
		if( page == null || page.length == 0 ) {
			throw new BtreeException("y[W̃oCg񂪎w肳ĂȂCoCg񂪋ł");
		}

		_order = order;
		_pageno = pageno;
		_keys = new BtreeKey[ order ];
		_children = new long[ order +1 ];			// qm[hւ̃N̓L[̐+1쐬
		_keyCount = 0;

		_tempForPromoKey = new BtreeKey[order+1];
		_tempForPromoPtr = new long[order+1+1];

		init();
		cleanTemp();

		// w肳ꂽoCg񂩂y[W̓e𕜌
		byteStreamToBtreePage(page, Integer.parseInt(factory.getProperty().getProperty(BtreeFile.KEYSIZE)));
	}

	/**
	 * ̃y[W̃y[WԍԂ
	 *
	 * @return long y[Wԍ
	 */
	public long getPageNo() {
		return _pageno;
	}
	/**
	 * ̃y[W̃y[WԍĐݒ肷
	 * 
	 * @param pn y[Wԍ(NEW_PAGE: Vy[WԍIɊU)
	 */
	public void setPageNo(long pn) {
		_pageno = pn;
	}
	/**
	 * i[ĂL[̐Ԃ
	 *
	 * @return int L[̐( < _order)
	 */
	public int keyCount() {
		return _keyCount;
	}

	/**
	 * ̃y[W̎Ԃ
	 *
	 * @return int 
	 */
	public int order() {
		return _order;
	}

	/**
	 * qm[hɑ΂郊NԂ
	 *
	 * @return int N(+1)
	 */
	public int children() {
		return _children.length;
	}
	/**
	 * i[ĂL[SĂԂ
	 * @return L[̔z
	 */
	public synchronized BtreeKey[] getKeys() {
		BtreeKey[] bkeys = new BtreeKey[_keyCount];
		System.arraycopy(_keys, 0, bkeys, 0, _keyCount);

		return bkeys;
	}
	/**
	 * VL[}D<br>
	 * VL[Ƀy[WɊi[ĂꍇCBtreeManipulation
	 * ExceptionD<br>
	 * VL[}悤ƂI/OG[ꍇCIOException
	 * D<br>
	 * ȊȌꍇKL[͑}łDC}ɂĕƏi
	 * ꍇCiΏۂ̃L[ԂDc[\ɕωȂꍇ
	 * nullԂD
	 *
	 * @param ikey }L[
	 * @param rchild }L[̉Ẽm[h(y[Wԍ)
	 * @return PromoResult Əȉ(null:ƏiȂ)
	 * @exception BtreeManipulationException ɂL[}悤Ƃ
	 * @exception IOException }ɉ炩I/OG[
	 */
	public synchronized PromoResult insert(BtreeKey ikey, long rchild) throws BtreeException, BtreeManipulationException, IOException {
		if( ikey == null ) {
			throw new BtreeManipulationException("L[NULLł");
//		} else if( shouldBeContained(ikey) == false ) {
//			shouldBeContained(ikey);
//			throw new BtreeManipulationException("w肳ꂽL[:" + ikey + " ́C̃y[WɊi[ׂł͂܂");
		}

		cleanTemp();

		/*
		 * ݐݒ肳ĂL[mFCip̃e|փRs[
		 */
		int pkey = 0;		// }X^
		int ptmp = 0;		// Ɨ̈
		boolean isCopied = false;
		boolean isReplaced = false;

		_tempForPromoPtr[0] = _children[0];						// ԍ̎qRs[ȂASY̊֌WKvȑ[u
		int cnt = 0;
		while(pkey  < _keyCount) {
			if(_keys[pkey].equals(ikey) == true) {
				// L[ꍇC㏑XV
				_keys[pkey] = ikey;
				isCopied = true;
				isReplaced = true;
//				// L[Ɋi[Ăꍇ̓G[
//				throw new BtreeManipulationException("L[:" + ikey + " ́CɊi[Ă܂");
			} else if( isCopied == false && ikey.isLessThan(_keys[pkey]) == true ) {
				// }X^̃L[}\̃L[̂قꍇCƗ֑̈}\̃L[
				_tempForPromoKey[ptmp++] = ikey;
				_tempForPromoPtr[ptmp] = rchild;				// L[̉Ẽm[hRs[̂ŁCptmp͂ł悵
				isCopied = true;
			}

			// Ɨ̈փRs[
			_tempForPromoKey[ptmp++] = _keys[pkey++];
			_tempForPromoPtr[ptmp] = _children[pkey];			// L[̉Ẽm[hRs[̂ŁCptmp/pkey͂ł悵
		}
		if( isCopied == false ) {
			// ̃[vŃe|̈Ɉ̃L[Rs[ĂȂꍇ
			_tempForPromoKey[ptmp++] = ikey;
			_tempForPromoPtr[ptmp] = rchild;					// L[̉Ẽm[hRs[̂ŁCptmp͂ł悵
		}
		if(isReplaced == true) {
			// PȂL[̒ȕꍇCc[\ɕύXȂ̂ŁĈ܂ܖ߂
			return null;
		}
		/*
		 * L[SĖ܂ĂꍇC}ƕK1͏i
		 * ȉꍇCK^̃L[iΏۂƂȂ
		 */
		if(_keyCount < _order) {
			// ̃L[܂܂ĂȂꍇCƗp̔z񂩂}X^փRs[
			// ȂCL[tłȂꍇ͏iȂ̂ŁCnullԂ
			System.arraycopy( _tempForPromoKey, 0, _keys, 0, _keyCount+1 );
			System.arraycopy( _tempForPromoPtr, 0, _children, 0, _keyCount+2 );
			if(isReplaced == false) {
				_keyCount++;
			}
			return null;
		} else {
			// îŏiL[Ԃ
			// y[W̓e͂̂܂܂ɂĂD
			// iΏۂ̃L[ƁCL[̈ʒu߂
			int promoKeyIdx = _order / 2 + _order % 2;
			BtreeKey promoKey = _tempForPromoKey[promoKeyIdx];

			/*
			 * Z̃y[W쐬
			 */
			BtreeKey[] brotherKeys = new BtreeKey[(_tempForPromoKey.length -1) - promoKeyIdx];
			long[] brotherChildren = new long[brotherKeys.length +1];

			System.arraycopy( _tempForPromoKey, promoKeyIdx+1, brotherKeys, 0, brotherKeys.length );
			System.arraycopy( _tempForPromoPtr, promoKeyIdx+1, brotherChildren, 0, brotherKeys.length+1 );
			BtreePage brother = new BtreePage(_factory, _pageno +1, brotherKeys, brotherChildren);

			// ČZ̃y[WֈړL[ƃ|C^
			_keys = new BtreeKey[_order];
			_children = new long[_order+1];
			System.arraycopy(_tempForPromoKey, 0, _keys, 0, promoKeyIdx);
			System.arraycopy(_tempForPromoPtr, 0, _children, 0, promoKeyIdx+1);
			_keyCount = promoKeyIdx;

			// ƏȉCĂяo֕Ԃ
			// BtreePageł́Cf[^XgAɑ鏈sȂȂ߁CĂяoŏ
			PromoResult pr = new PromoResult( promoKey, brother );
			return pr;
		}
	}

	/**
	 * w肳ꂽ\ɑΉL[ԂD<br>
	 * w肳ꂽ\ɑΉL[C̃y[Wɑ݂
	 * L[IuWFNgC݂ȂꍇnullԂ
	 *
	 * @param key L[̕\
	 * @return BtreeKey YL[(݂Ȃꍇnull)
	 */
	public BtreeKey find(String key) {
		for( int i = 0; i < _keyCount; i++ ) {
			if( key.equals( _keys[i].toString() ) ) {
				return _keys[i];
			}
		}
		return null;
	}

	/**
	 * w肳ꂽL[̃y[WɊ܂܂ׂǂԂD
	 * ۂɑ}ł邩ǂԂ킯ł͂ȂƂɒ
	 *
	 * @param key L[
	 * @return boolean true: ܂܂ׂł / false: Ⴄy[Wɑ}Kv
	 */
	public boolean shouldBeContained( BtreeKey key ) {
		return getChildPageNo(key) < 0;
	}
	/**
	 * w肳ꂽʒũm[hԍXV
	 * @param idx CfbNX
	 * @param pageno y[Wԍ
	 */
	void setChildNodeAt(int idx, long pageno) {
		_children[idx] = pageno;
	}
	public long getChildNodeAt(int idx) {
		return _children[idx];
	}
	/**
	 * w肳ꂽL[̍̎qݒ肷
	 * @param key L[
	 * @param pageno y[Wԍ
	 */
	public void setLeftChildOf(BtreeKey key, long pageno) {
		for(int i = 0; i < _keyCount; i++) {
			if(key.equals(_keys[i].toString())) {
				_children[i] = pageno;
				return;
			}
		}
	}
	/**
	 * w肳ꂽL[̉E̎qݒ肷
	 * @param key L[
	 * @param pageno y[Wԍ
	 */
	public void setRightChildOf(BtreeKey key, long pageno) {
		for(int i = 0; i < _keyCount; i++) {
			if(key.equals(_keys[i].toString())) {
				_children[i+1] = pageno;
				return;
			}
		}
	}
	/**
	 * w肳ꂽL[}ׂCqKw̃y[Wԍ擾
	 * @param key L[
	 * @return y[Wԍ -1:qKwȂ 0ȏ: y[Wԍ
	 * @throws BtreeException Ɏs
	 */
	public long getChildPageNo(BtreeKey key) {
		if( _keyCount == 0 ) {
			// L[i[ĂȂꍇCi[ł͂Ȃ̂true
			return -2;
		}
		BtreeKey theGreaterKey = null;
		int offsetOfTheGreaterKey = -1;

		for( int i = 0; i < _keyCount; i++ ) {
			if(key.equals(_keys[i])) {
				// SL[̂ŁCv[X
				return -2;
			} else if(key.isLessThan(_keys[i])) {
				// w肳ꂽL[傫̂𔭌̂Œf
				offsetOfTheGreaterKey = i;
				break;
			}
		}
		if(offsetOfTheGreaterKey == -1) {
			// w肳ꂽL[傫̂Ȃꍇ
			// ̃y[ẄԉE̎q̃y[Wԍꍇ͂D
			// ԉE-1̏ꍇ(̊Kw݂Ȃꍇ)́C-2
			if(getChildNodeAt(_keyCount) > 0) {
				return getChildNodeAt(_keyCount);
			} else {
				return -2;
			}
		} else {
			// 傫L[𔭌ꍇ
			// 傫L[̍̎q̃y[Wԍw肳Ăꍇ(=̊Kwꍇ)
			// wL[͉̊KwɊi[ׂ
			if(_children[offsetOfTheGreaterKey] >= 0) {
				return _children[offsetOfTheGreaterKey];
			} else {
				// }ׂʒuɑ΂āC̊KwȂ
				return -1;
			}
		}
	}
	/**
	 * w肳ꂽL[̃y[WɊ܂܂Ă邩ǂԂD<br>
	 * ܂܂ĂꍇtrueC܂܂ĂȂꍇfalseԂ
	 *
	 * @param key mFL[
	 * @return boolean true: ݂ / false: ݂Ȃ
	 */
	public boolean isContained( BtreeKey key ) {
		return find( key.toString() ) != null;
	}

	/**
	 * w肳ꂽL[폜D<br>
	 * 폜ɐꍇtrueCߑaꍇfalse<br>
	 * ԂD<br>
	 * 폜I/OG[ꍇCIOExceptionD
	 *
	 * @param key 폜L[
	 * @return boolean true:  / false: ߑa
	 * @exception IOException 폜I/OG[ꍇ
	 */
	public boolean delete( String key ) throws IOException {
		return true;
	}

	/**
	 * w肳ꂽL[폜D<br>
	 * 폜ɐꍇtrueCߑaꍇfalse<br>
	 * ԂD<br>
	 * 폜I/OG[ꍇCIOExceptionD
	 *
	 * @param key 폜L[
	 * @return boolean true:  / false: ߑa
	 * @exception IOException 폜I/OG[ꍇ
	 */
	public boolean delete( BtreeKey key ) throws IOException {
		return delete( key.toString() );
	}

	/**
	 * Btree̓e
	 */
	protected void init() {
		for( int i = 0; i < _children.length; i++ ) {
			_children[i] = -1L;
		}
	}

	/**
	 * ip̃e|̈NA
	 */
	protected void cleanTemp() {
		for( int i = 0; i < _tempForPromoKey.length; i++ ) {
			_tempForPromoKey[i] = null;
			_tempForPromoPtr[i] = -1L;
		}

		// m[h֌Wp̔źCL[p1
		_tempForPromoPtr[_tempForPromoKey.length] = -1L;
	}

	/**
	 * w肳ꂽL[́Cy[Wł̊i[ʒuԂ
	 *
	 * @return int ԍ̃CfbNX(0x[X)
	 * @exception BtreeManipulationException w肳ꂽ[ȂȂ
	 */
	protected int indexOf(BtreeKey key) throws BtreeManipulationException {
		for( int i = 0; i < _keyCount; i++ ) {
			if( key.equals( _keys[i].toString() ) ) {
				return i;
			}
		}

		throw new BtreeManipulationException("w肳ꂽL[[" + key +"]Ȃ");
	}
	/**
	 * w肳ꂽL[̉E̎qԂ
	 *
	 * @return long E̎q -1:qȂ
	 * @exception BtreeManipulationException w肳ꂽL[ȂȂ
	 */
	public long rightChildOf(BtreeKey key) throws BtreeManipulationException {
		return _children[ indexOf(key)+1 ];
	}
	/**
	 * w肳ꂽL[̍̎qԂ
	 *
	 * @return long ̎q -1:qȂ
	 * @exception BtreeManipulationException w肳ꂽL[ȂȂ
	 */
	public long leftChildOf(BtreeKey key) throws BtreeManipulationException {
		return _children[ indexOf(key) ];
	}

	/**
	 * ̃y[W̃oCgXg[Ԃ
	 * @param buffer oCgXg[i[obt@
	 * @return oCgXg[
	 * @exception oCgXg[ɕϊłȂ
	 */
	public byte[] getByteStream() throws BtreeException {
		// L[1̃oCgTCY擾
		int keyByteSize = _factory.keyByteSize();
		int pageByteSize = keyByteSize * _order + 8 * (_order+1) +4;
		byte[] buffer = new byte[pageByteSize];

		// Ɨp̃obt@쐬(rbOGfBA)
		ByteBuffer bf = ByteBuffer.allocate(pageByteSize).order(ByteOrder.BIG_ENDIAN);
		bf.rewind();

		// L[JEg̏o
		if(isEnabled() == true) {
			bf.putInt(_keyCount);
		} else {
			// y[WgpĂȂꍇCL[JEg-1ŌŒ
			bf.putInt(-1);
		}

		// L[̏o
		byte[] emptyKey = new byte[keyByteSize];
		for(int i = 0; i < _keys.length; i++) {
			if(_keys[i] != null) {
				bf.put(_keys[i].byteStream());
			} else {
				bf.put(emptyKey);
			}
		}
		// qm[hւ̃N̏o
		for(int j = 0; j < _children.length; j++) {
			bf.putLong(_children[j]);
		}
		// ʂԂDƂēnꂽoCgz̃TCY萶ꂽoCgẑق
		// 傫ꍇCO
		byte[] ba = bf.array();
		try {
			System.arraycopy(ba, 0, buffer, 0, ba.length);
		} catch(Exception e) {
			throw new BtreeException(e.getMessage());
		}
		return buffer;
	}
	/**
	 * oCg񂩂y[W̓e𕜌D<br>
	 * łȂꍇBtreeExceptionD
	 * @param stream oCg
	 * @param keyByteSize L[̃oCgTCY
	 * @throws BtreeException Ɏs
	 */
	protected void byteStreamToBtreePage(byte[] stream,int keyByteSize) throws BtreeException {
		int pageStreamSize = keyByteSize * _order + 8 * (_order+1) + 4;
		if(pageStreamSize != stream.length) {
			throw new BtreeException("oCgf[^̒ƃy[W̐ݒlႤ");
		}

		try {
			ByteBuffer buffer = ByteBuffer.allocate(pageStreamSize).order(ByteOrder.BIG_ENDIAN);
			buffer.rewind();
			buffer.put(stream);
			buffer.rewind();

			// i[ĂL[̐𕜌
			_keyCount = buffer.getInt();
			if(_keyCount == -1) {
				// L[̐-1̏ꍇC̃y[W͎gĂȂƔ肷
				_keyCount = 0;			// Ô
				_pageno = -1;			// y[Wԍ-1
				setEnabled(false);
				return;
			}
			byte[] keyBuffer = new byte[keyByteSize];

			// L[̕
			for(int i = 0; i < _keys.length; i++) {
				buffer.get(keyBuffer);
				_keys[i] = _factory.newKey(keyBuffer);
			}

			// qm[hւ̃N̕
			for(int j = 0; j < _children.length; j++) {
				_children[j] = buffer.getLong();
			}
		} catch(Exception e) {
			e.printStackTrace();
			throw new BtreeException("y[W̕ɃG[܂");
		}
	}
	/**
	 * ̃y[WLǂԂ
	 * 
	 * @return (true:L / false:)
	 */
	public boolean isEnabled() {
		return enabled;
	}
	/**
	 * ̃y[W̗L/ݒ肷<br>
	 * ɐݒ肵ăt@CɃR~bgꍇCy[Ẅ掩͍̂폜ꂸ
	 * ėp̃tO
	 * 
	 * @param status true:L / false:
	 */
	public void setEnabled(boolean status) {
		enabled = status;
	}
	/**
	 * iL[ѕɂĐV쐬ꂽy[Wi[\<br>
	 * BtreePage.insert()sۂ̖߂l̂߂̌^D<br>
	 * V쐬ꂽy[Wɂ́Cy[Wԍ蓖ĂȂ߁Čʂ󂯎NXsKvD<br>
	 * ܂CiL[̉Ẽm[h(y[Wԍ)́CV쐬y[W̔ԍɂȂ邽߁CɂĂʂ󂯎NXݒ肷KvD<br>
	 *
	 * @author satoshi akabane
	 * @version 1.0
	 */
	public class PromoResult {
		final BtreeKey _promoKey;			// iL[
		final BtreePage _page;				// ɂĔCZ̃y[W

		/**
		 * RXgN^
	 	 * @param pk iL[
		 * @param bp ɂĐV쐬ꂽy[W(ꂽy[W̌Zɑ)
		 */
		PromoResult( BtreeKey pk, BtreePage bp ) {
			_promoKey = pk;
			_page = bp;
		}
	}
}

// end of BtreePage.java
