/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.*;

import org.logical_paradox.common.io.ByteStream;

/**
 * B-treẽL[Ǘ钊ۃNXD<br>
 * 1̃y[Wɕ̃L[܂܂D<br>
 * L[̓eɂĂ̓TuNXŎD<br>
 * @author satoshi akabane
 * @version 1.0
 */
public abstract class BtreeKey implements Serializable, ByteStream {
	/**
	 * @exception BtreeException
	 */
	public BtreeKey( byte[] bstream ) throws BtreeException {
		byteStreamToBtreeKey( bstream );
	}
	public BtreeKey(Object o) throws BtreeException {
		objectToBtreeKey(o);
	}
	/**
	 * IuWFNgBtreeKey̎̂𐶐D
	 * @param o IuWFNg
	 * @throws BtreeException ̉Ɏs
	 */
	protected abstract void objectToBtreeKey(Object o) throws BtreeException;
	/**
	 * oCg񂩂BtreeKey̎̂𐶐D
	 * @param bstream oCg
	 * @throws BtreeException ̉Ɏs
	 */
	protected abstract void byteStreamToBtreeKey( byte[] bstream ) throws BtreeException;

	/**
	 * L[̕`ԂD
	 * @return String L[̕`
	 */
	public abstract String toString();

	/**
	 * L[rD
	 * @param obj rΏ
	 * @return boolean true: ł / false: Ⴄ
	 */
	public abstract boolean equals( Object obj );

	/**
	 * w肳ꂽL[菬ǂԂ
	 * @param key rΏ
	 * @return boolean true: this < key / false: this >= key
	 */
	public abstract boolean isLessThan( BtreeKey key );

	/**
	 * w肳ꂽL[傫ǂԂ
	 * @param key rΏ
	 * @return boolean true: this > key / false: this <= key
	 */
	public abstract boolean isGreaterThan( BtreeKey key );

	/**
	 * L[̃oCgXg[ԂD<br>
	 * iXg[Wɑ΂ăL[ۑۂɁCBtreePageɂ
	 * ĂяoD
	 * @return byte[] oCg
	 */
	public abstract byte[] byteStream();

	/**
	 * oCgXg[ɂۂ̃TCY
	 * @return int oCg\ɂꍇ̃TCY
	 */
	public int byteSize() {
		return byteStream().length;
	}
}

// end of BtreeKey.java
