/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.*;
import java.util.Properties;

import org.logical_paradox.common.io.CommonRandomAccessFileDelegator;
import org.logical_paradox.common.io.RandomAccessFileDelegator;


/**
 * ̃CuŎgpf[^t@CǗNXD<br>
 * B-tree̍\Ɋւf[^́C̃NXɊi[C̃NXŏo͂D
 * @author satoshi akabane
 * @version 1.0
 */
public class BtreeFile {
	/*
	 * vpeBŎw肷p[^̃L[̒l(K{)
	 */
	public static final String FILENAME = "btreefile.filename";				// t@C
	public static final String MAGIC_NUMBER = "btreefile.magicnumber";		// }WbNio[(4oCg)
	public static final String MAJOR_VERSION = "btreefile.majorversion";		// W[o[W()
	public static final String MINOR_VERSION = "btreefile.minorversion";		// }Ci[o[W()
	public static final String HEADER_SIZE = "btreefile.headersize";			// wb_ubÑTCY()
	public static final String ORDER = "btreefile.order";					// ()
	public static final String KEYSIZE = "btreefile.keysize";				// L[̑傫(oCg,)

	/*
	 * vpeBŎw肷p[^̃L[̒l(CӍ)
	 */
	public static final String ROOT_PAGE = "btreefile.rootpage";				// [g̃y[Wԍ()
	public static final String MAX_ASSIGNED_PAGE = "btreefile.maxassignedpage";	// ݊蓖ĂĂő̃y[Wԍ()

	protected byte[] _magicNumber = new byte[4];				// }WbNio[(4oCgŒ)
	protected byte _majorVersion;								// t@CtH[}bg̃W[o[W
	protected byte _minorVersion;								// t@CtH[}bg̃}Ci[o[W
	protected int _sizeOfHeader;								// wb_̃TCY
	protected long _rootPageNo;								// [g̃y[Wԍ(-1: [gȂ)
	protected int _order;										// 
	protected int _keysize;									// L[̃oCgTCY
	protected long _maxAssignedPageNo;						// ݊蓖ĂĂő̃y[Wԍ
	protected BtreeFactory _factory = null;					// t@Ng
	protected RandomAccessFileDelegator _btfile;				// Ώۃt@C
	protected BtreeAvailableList _fragment;					// B-treefЉR[ht@C

	/**
	 * ftHgRXgN^
	 *
	 */
	protected BtreeFile() {
	}
	/**
	 * evpeBw肷邱Ƃ̂łRXgN^
	 * @param factory t@Ng
	 * @param prop vpeB
	 * @exception BtreeException w肳ꂽnhꍇ
	 */
	public BtreeFile(BtreeFactory factory, Properties prop) throws BtreeException {
		_factory = factory;

		setProperty(prop);
		try {
			_btfile = openPhysicalFile(prop.getProperty(BtreeFile.FILENAME));
			// fЉR[ht@C쐬
			_fragment = _factory.getBtreeAvailableList(prop.getProperty(BtreeFile.FILENAME)+".fgm");
		} catch( Exception e ) {
			throw new BtreeException( e.getMessage() );
		}
	}
	/**
	 * t@CI[v
	 * @param filename t@C
	 * @return t@Cւ̎Q
	 * @throws Exception 炩̗Oꍇ
	 */
	protected RandomAccessFileDelegator openPhysicalFile(String filename) throws Exception {
		return new CommonRandomAccessFileDelegator(filename, "rw");
	}
	/**
	 * vpeBݒ肷
	 * @param prop vpeB
	 * @throws BtreeException vpeBɊԈႢꍇ
	 */
	protected void setProperty(Properties prop) throws BtreeException {
		try {
			// 킴ƗO₷悤ȃR[fBOɂĂ(check̈)
			_btfile = openPhysicalFile(prop.getProperty(BtreeFile.FILENAME));
			byte[] magicNumber = prop.getProperty(BtreeFile.MAGIC_NUMBER).getBytes();
			_magicNumber[0] = magicNumber[0];
			_magicNumber[1] = magicNumber[1];
			_magicNumber[2] = magicNumber[2];
			_magicNumber[3] = magicNumber[3];

			setVersion(Integer.parseInt(prop.getProperty(BtreeFile.MAJOR_VERSION)),
					Integer.parseInt(prop.getProperty(BtreeFile.MINOR_VERSION)));

			_sizeOfHeader = Integer.parseInt(prop.getProperty(BtreeFile.HEADER_SIZE));
			_order = Integer.parseInt(prop.getProperty(BtreeFile.ORDER));
			_keysize = Integer.parseInt(prop.getProperty(BtreeFile.KEYSIZE));

			// ȍ~̓IvV̍
			String rootpage = prop.getProperty(BtreeFile.ROOT_PAGE);
			if(rootpage != null) {
				_rootPageNo = Long.parseLong(rootpage);
			}
			String maxAssignedPage = prop.getProperty(BtreeFile.MAX_ASSIGNED_PAGE);
			if(maxAssignedPage != null) {
				_maxAssignedPageNo = Long.parseLong(maxAssignedPage);
			}
		} catch(Exception e) {
			throw new BtreeException("vpeBɊԈႢ܂");
		}
	}
	/**
	 * ݊蓖ĂĂő̃y[WԍԂ
	 * @return y[Wԍ
	 */
	public long getMaxAssignedPageNo() {
		return _maxAssignedPageNo;
	}
	/**
	 * ̃t@CN[Y
	 * @exception IOException N[YɎs
	 */
	public void close() throws IOException {
		try {
			// fЉR[ht@Cɏo͂鏈
			_fragment.flush();
			flush();
		} catch(BtreeException be) {
			throw new IOException(be.getMessage());
		}
		_btfile.close();
		_btfile = null;
	}
	/**
	 * ̃t@CĂ邩ǂԂ
	 * @return true:Ă / false:JĂ
	 */
	public boolean isClosed() {
		return _btfile == null;
	}
	/**
	 * _ł̃[gy[WԍԂ
	 * @return long [g̃y[Wԍ
	 */
	public long getRootPageNo() {
		return _rootPageNo;
	}

	/**
	 * }WbNwb_𕶎ŕԂ
	 * @return String }WbNio[(4)
	 */
	public String getMagicNumber() {
		try {
			return new String( _magicNumber, "US-ASCII" );
		} catch( UnsupportedEncodingException uee ) {
			return null;
		}
	}

	/**
	 * }WbNio[ݒ肷
	 * @param magicNumber }WbNio[(oCgz4vf)
	 * @exception IllegalArgumentException
	 */
	public void setMagicNumber( byte[] magicNumber ) throws IllegalArgumentException {
		if( magicNumber == null || magicNumber.length != 4 ) {
			throw new IllegalArgumentException( "}WbNio[͗vf4̃oCgzŎw肵Ă" );
		}
		_magicNumber = new byte[ magicNumber.length ];
		System.arraycopy( magicNumber, 0, _magicNumber, 0, _magicNumber.length );
	}

	/**
	 * t@CtH[}bg̃W[o[WԂ
	 * @return int W[o[W
	 */
	public int getMajorVersion() {
		return (int)_majorVersion;
	}

	/**
	 * t@CtH[}bg̃}Ci[o[WԂ
	 * @return int }Ci[o[W
	 */
	public int getMinorVersion() {
		return _minorVersion;
	}

	/**
	 * t@C̃o[Wݒ肷
	 */
	public void setVersion( int major, int minor ) {
		_majorVersion = (byte)major;
		_minorVersion = (byte)minor;
	}

	/**
	 * wb_̃TCYԂ
	 *
	 * @return int wb_ubÑTCY
	 */
	public int getHeaderSize() {
		return _sizeOfHeader;
	}

	/**
	 * t@CTCYԂ
	 * @return long t@CTCY
	 */
	public long length() {
		try {
			return _btfile.length();
		} catch( IOException e ) {
			return 0;
		}
	}

	/**
	 * wb_ubN[hD
	 * [hƁCV[N|C^ړ̂Œӂ邱<br>
	 * ܂Cwb_ubÑ[hꍇCf[^ubN̏I[ĂD
	 * @exception IOException t@CANZXɃG[ꍇ
	 * @exception BtreeException B-treẽf[^t@CƂč\ꍇ
	 */
	public void reload() throws IOException, BtreeException {
		// V[N|C^擪6oCgڂɈړ
		// 6oCgڂɂ́C32bitŃwb_ubN̒i[Ă邽
		_btfile.seek(6);

		// wb_ubN̒ǂݍ
		try {
			_sizeOfHeader = _btfile.readInt();
			_btfile.seek(0);

			// wb_ubNŜǂݍ
			// ̒iKŁCt@C|C^̓f[^ubN̐擪Ă͂
			byte[] headerBlock = new byte[_sizeOfHeader];
			_btfile.readFully( headerBlock );
			DataInputStream din = new DataInputStream( new ByteArrayInputStream( headerBlock ) );

			// }WbNio[̃[h
			_magicNumber[0] = din.readByte();
			_magicNumber[1] = din.readByte();
			_magicNumber[2] = din.readByte();
			_magicNumber[3] = din.readByte();

			// t@CtH[}bg̃o[W[h
			_majorVersion = din.readByte();
			_minorVersion = din.readByte();

			// wb_TCỸ[h
			_sizeOfHeader = din.readInt();

			// [gy[Wԍ̃[h
			_rootPageNo = din.readLong();

			// ݊蓖ĂĂő̃y[Wԍ
			_maxAssignedPageNo = din.readLong();

			din.close();
		} catch( IOException ioe ) {
			ioe.printStackTrace();
			throw new BtreeException( ioe.getMessage() );
		}
	}

	/**
	 * wb_ubNށD
	 * wb_ubN񂾏ꍇCV[N|C^͈x擪ɖ߂C񂾌
	 * f[^ubN̐擪ɈړD
	 * @exception IOException t@CANZXɃG[ꍇ
	 * @exception BtreeException B-treẽf[^t@CƂč\ꍇ
	 */
	public void flush() throws IOException, BtreeException {
		ByteArrayOutputStream bao = new ByteArrayOutputStream(_sizeOfHeader);
		DataOutputStream dos = new DataOutputStream( bao );

		try {
			// }WbNio[
			dos.write( _magicNumber, 0, _magicNumber.length );

			// t@CtH[}bg̃o[W
			dos.writeByte( _majorVersion );
			dos.writeByte( _minorVersion );

			// wb_TCY
			dos.writeInt( _sizeOfHeader );

			// [gy[Wԍ
			dos.writeLong( _rootPageNo );

			// ݊蓖ĂĂő̃y[Wԍ
			dos.writeLong( _maxAssignedPageNo );

			// f[^ubN̐擪ɃV[N鏈
			byte[] headerBlock = new byte[_sizeOfHeader];
			byte[] storedByteArray = bao.toByteArray();
			System.arraycopy(storedByteArray, 0, headerBlock, 0, storedByteArray.length);
			_btfile.seek(0);
			_btfile.write( headerBlock );
		} catch( ArrayIndexOutOfBoundsException be ) {
			be.printStackTrace();
			throw new BtreeException( be.getMessage() );
		}
	}
	/**
	 * Vy[W쐬
	 * 
	 * @return ꂽy[W
	 */
	public BtreePage newPage() throws BtreeException {
		BtreePage btp = null;
		synchronized(this) {
			// y[Ẅ悪邯ǎgĂȂy[WT
			long unusedPageNo = findEmptyPage();
			if(unusedPageNo > -1) {
				// ̂ōėp
				btp = getPage(unusedPageNo);
				btp.init();				// ꉞĂԂ
				btp.setPageNo(unusedPageNo);
				btp.setEnabled(true);
				return btp;
			}
			// Vy[W쐬
			_maxAssignedPageNo++;
			btp = new BtreePage(_factory, _maxAssignedPageNo);
			if(_maxAssignedPageNo == 1 && _rootPageNo <= 0) {
				// [g̃y[W܂ݒ肳ĂȂꍇCV쐬ꂽy[W[gƂ
				_rootPageNo = _maxAssignedPageNo;
			}
			// wb_ubNXg[Wɏ
			try {
//				flush();
				// t@C̏I[܂ŃV[N
				_btfile.seek(_btfile.length());
				// t@C̏I[Ƀy[W̃oCiXg[o͂
				_btfile.write(btp.getByteStream());
			} catch(Exception ioe){
				// wb_ubN̏o͒ɃG[ɂȂ̂ŁC_rootPageNo̐ۂ
				_maxAssignedPageNo--;
				throw new BtreeException("o͒ɃG[");
			}
		}

		return btp;
	}
	/**
	 * w肳ꂽy[WXg[W畜ĕԂ
	 * 
	 * @param pageno y[Wԍ
	 * @return ꂽy[W
	 * @throws BtreeException 쒆ɔO
	 */
	protected BtreePage getPage(long pageno) throws BtreeException {
		int pageSize = getPageSize();
		if(pageno <= 0) {
			// y[Wԍ0ȉ̏ꍇC[g̃y[W擾
			pageno = getRootPageNo();
			if(pageno <= 0) {
				// [gy[Ŵ݂Ȃ
				return null;
			}
		}
		long seekp = (long)pageSize * (pageno-1) + getHeaderSize();
		try {
			_btfile.seek(seekp);
			byte[] pageStream = new byte[pageSize];
			_btfile.read(pageStream);
			BtreePage btpage = new BtreePage(_factory, pageno, pageStream);

			return btpage;
		} catch( IOException ioe ) {
			throw new BtreeException(ioe.getMessage());
		}
	}
	/**
	 * y[W̃TCYԂ
	 *
	 * @return int y[W̃oCgTCY
	 * @see org.logical_paradox.common.btree.BtreeFactory
	 * @see org.logical_paradox.common.btree.BtreePage
	 */
	protected int getPageSize() {
		int keyByteSize = _keysize;

		// |C^longȂ̂8oCgł
		// Ō4oCg̓L[JEg
		return (keyByteSize * _order) + (8 * (_order+1)) + 4;
	}
	/**
	 * w肳ꂽy[WԍɑΉt@C̃V[N|C^Ԃ
	 * @param pageno y[Wԍ
	 * @return V[N|C^
	 */
	public long calcSeekPointer(long pageno) {
		return (long)getPageSize() * (pageno-1) + getHeaderSize();
	}
	/**
	 * w肳ꂽy[Wt@CVXeŒu
	 * @param btp uΏۃy[W(݂Ȃꍇ͒ǉ)
	 * @throws BtreeException uɉ炩I/OG[
	 */
	public void replacePage(BtreePage btp) throws BtreeException {
		byte[] page = btp.getByteStream();
		long seekp = calcSeekPointer(btp.getPageNo());

		try {
			// t@CɃy[Wo͂
			_btfile.seek(seekp);
			_btfile.write(btp.getByteStream());

			// w肳ꂽy[WԂ̏ꍇCy[Wԍ-1ɐݒ肷
			if(btp.isEnabled() == false) {
				// fЉR[hƂēo^
				_fragment.getCache().add(new Long(btp.getPageNo()));
				// ̍śCfЉ̌Ɏs
				btp.setPageNo(-1);
			}
		} catch(IOException ioe) {
			throw new BtreeException(ioe.getMessage());
		}
	}
	/**
	 * [gy[W̔ԍXV
	 * 
	 * @param l Vy[Wԍ
	 */
	protected synchronized void replaceRootPageNo(long l) throws BtreeException {
		long before = _rootPageNo;
		try {
			_rootPageNo = l;
//			flush();
		} catch(Exception e) {
			// m񂪁Cwb_ubN̍XVɎŝŌɖ߂
			_rootPageNo = before;
			e.printStackTrace();
			throw new BtreeException(e.getMessage());
		}
	}
	/**
	 * gp̈T
	 * T͂낢날Ǝv..
	 * 
	 * @return long XĽʁCgpƔ肳ꂽy[Wԍ(-1:łȂ)
	 */
	protected synchronized long findEmptyPage() throws BtreeException {
		Long l = (Long)_fragment.getCache().getOne();
		return l == null ? -1 : l.longValue();
	}
}

// end of BtreeFile.java
