/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.util.HashMap;
import java.util.Properties;

/**
 * BtreeCup̃f[^\𐶐t@NgNX̂߂abstract factoryD<br>
 * AvP[V͕K̊NXNX𐶐KvD<br>
 * ̃t@Ngł́CBtreeKey̎BtreeObject̎ԂD
 * @author satoshi akabane
 * @version 1.0
 */
public abstract class BtreeFactory {
	public static final String DEFAULT_BTREE_FACTORY = "org.logical_paradox.common.btree.DefaultBtreeFactory";
	public static final String JVM_SPECIFIED_BTREE_FACTORY_KEY = "org.logical_paradox.common.btree.factory_class";

	// t@Ngv[
	private static final HashMap _factoryPool = new HashMap();

	// ftHgRXgN^
	protected BtreeFactory() {
	}
	/**
	 * JVMŎw肳ꂽNXBtreet@Ng𐶐D<br>
	 * JVMŎw肳ĂȂꍇCftHg̃t@NgID
	 * @return ꂽbtreet@Ng
	 * @throws Exception t@NgNX̐Ɏs
	 */
	public static final BtreeFactory getInstance() throws Exception {
		String factoryClassName = System.getProperty(JVM_SPECIFIED_BTREE_FACTORY_KEY);
		if(factoryClassName == null || factoryClassName.trim().length() == 0) {
			// JVM̈Ńt@Ngw肳Ȃꍇ̓ftHg
			factoryClassName = DEFAULT_BTREE_FACTORY;
		}
		return BtreeFactory.getInstance(factoryClassName);
	}
	/**
	 * w肳ꂽNX̃t@Ng𐶐D<br>
	 * t@Ngt@Ngv[Ɋɑ݂ĂꍇCԂD<br>
	 * t@Ngt@Ngv[ɑ݂ȂꍇCVCX^X𐶐ĕԂCv[OD
	 * @param classname t@NgNX
	 * @return ꂽbtreet@Ng
	 * @throws Exception t@NgNX̐Ɏs
	 */
	public static final BtreeFactory getInstance(String classname) throws Exception {
		BtreeFactory factory = (BtreeFactory)_factoryPool.get(classname);
		if(factory == null || factory instanceof BtreeFactory) {
			factory = (BtreeFactory)Class.forName(classname).newInstance();
			_factoryPool.put(classname, factory);
		}
		return factory;
	}
	/**
	 * ̃t@NgŐt@C̐ݒlԂ
	 * 
	 * @return ݒl
	 * @throws BtreeException ݒlԂƂłȂꍇ
	 */
	protected abstract Properties getProperty() throws BtreeException;

	/**
	 * t@CnhԂ<br>
	 * ̃\bhĂяoĂCt@Ĉ̓I[vĂȂƂɒ
	 * 
	 * @param filename t@C
	 * @return BtreeFile t@C
	 * @throws BtreeException 炩̗RŃt@Cnh̐Ɏs
	 */
	public abstract BtreeFile getFileHandle(String filename) throws BtreeException;

	/**
	 * p\XgԂ
	 * C쐬ꂽp\Xg̓I[vȂ
	 * @param filename t@C
	 * @return p\Xg
	 * @throws BtreeException p\Xg̍쐬Ɏs
	 */
	public abstract BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException;
	/**
	 * VBtreeKeyԂ
	 *
	 * @param o IuWFNg
	 * @return BtreeKey L[
	 * @exception BtreeException Ɏsꍇ
	 * @see org.logical_paradox.common.btree.BtreeKey
	 */
	public abstract BtreeKey newKey(Object o) throws BtreeException;
	/**
	 * VBtreeKeyԂ
	 * @param stream oCg
	 * @return ꂽBtreeKey
	 * @throws BtreeException oCgBtreeKey̕łȂꍇ
	 */
	public abstract BtreeKey newKey(byte[] stream) throws BtreeException;

	/**
	 * BtreeKeỹoCgTCYԂ
	 *
	 * @return int oCgTCY
	 * @see org.logical_paradox.common.btree.BtreeKey
	 */
	public abstract int keyByteSize();
}

// end of BtreeFactory.java
