/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.logical_paradox.common.io.AvailableList;

/**
 * B-tree\Ŏgp闘p\Xgt@CɓeNX
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class BtreeAvailableList extends AvailableList {
	/**
	 * RXgN^
	 * @param filename t@C
	 */
	public BtreeAvailableList(String filename) {
		super(filename, 0);
	}
	/**
	 * RXgN^
	 * @param filename t@C
	 * @param size tOgRNṼTCY
	 */
	public BtreeAvailableList(String filename, int size) {
		super(filename, size);
	}
	/**
	 * oCg񂩂痘p\Xg𕜌鏈
	 * @param bstream oCg
	 * @throws IOException ɗO
	 */
	protected void restore(ByteBuffer buffer) throws IOException {
		while(buffer.hasRemaining()) {
			cache.add(new Long(buffer.getLong()));
		}
	}
	/**
	 * ɃLbVĂfЉt@Cɏo͂
	 * @throws IOException t@CANZXɎs
	 */
	public void flush() throws IOException {
		ByteBuffer buffer = ByteBuffer.allocate(cache.size() * 8).order(ByteOrder.BIG_ENDIAN);
		Long buf = null;

		// SĂ̒fЉR[hԍ擾ăoCgobt@֓o^
		while((buf = (Long)cache.getOne()) != null) {
			buffer.putLong(buf.longValue());
		}

		// ftHg̏o̓Xg[Jăt@C֏o͂
		OutputStream out = getOutputStream();
		out.write(buffer.array());
		out.close();
	}
}
