/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree;

import java.io.*;
import java.util.*;

import org.logical_paradox.common.thread.ReadWriteLock;

/**
 * B-tree\ǗNXD<br>
 * ̃NXʂāCiXg[WɕۊǂĂB-treef[^\
 * ɑ΂ăANZXD<br>
 * ̃Cu𗘗pvÓCBtreeKeyBtreeObjecth
 * Ǝ̃f[^\D<br>
 * ɂ肪ȂꍇCBtreeBtreePageNXgKv͂ȂD
 * @author satoshi akabane
 * @version 1.0
 */
public class Btree {
	private int _order = 0;								// 
	private String _filename = null;						// t@C
	private BtreeFile _file = null;						// t@C
	private BtreePage[] _cachedPages = null;				// y[W̃LbVpobt@
	private final BtreeFactory _factory;					// Btree̋̓IȐw肷t@NgNX
	private ReadWriteLock _lock = null;					// ReadersWriterbN

	/**
	 * RXgN^
	 */
	protected Btree( BtreeFactory factory ) {
		_factory = factory;
		_lock = new ReadWriteLock();
	}

	/**
	 * BtreeNX̃CX^X𐶐ĕԂ
	 *
	 * @param factory BtreeFactorỹCX^X
	 * @return Btree BtreeNX̃CX^X
	 * @exception BtreeException 炩̌ŃCX^X̐Ɏs
	 */
	public static Btree getInstance( BtreeFactory factory ) {
		return new Btree(factory);
	}

	/**
	 * Btreef[^t@CJ
	 *
	 * @param filename t@C
	 * @exception BtreeException
	 */
	public void open(String filename) throws BtreeException {
		open(filename, 0);
	}

	/**
	 * Btreef[^t@CJ
	 *
	 * @param filename t@C
	 * @param cachesize LbVy[W(0:LbVȂ)
	 * @exception BtreeException
	 */
	public void open(String filename, int cachesize) throws BtreeException {
		Properties prop = _factory.getProperty();
		_filename = filename;
		_order = Integer.parseInt(prop.getProperty(BtreeFile.ORDER));
		_filename = filename;
		_cachedPages = new BtreePage[ cachesize ];

		// t@C_ANZX`ŊJ
		try {
			_file = _factory.getFileHandle(filename);
			if( _file.length() > 0 ) {
				_file.reload();
			} else {
				// ߂č쐬ꂽt@C̏ꍇCwb_ubNo͂
				_file.flush();
			}
		} catch( Exception fn ) {
			throw new BtreeException(fn.getMessage());
		}
	}

	/**
	 * Btreê߂̃ZbVԂ
	 * @return ZbV
	 * @throws BtreeException
	 */
	public BtreeSession getSession() throws BtreeException {
		return new BtreeSession(this);
	}
	/**
	 * Btreef[^t@CD
	 * OɃwb_̍XVsȂ
	 *
	 * @exception BtreeException 炩̌ŃN[YłȂꍇ
	 */
	protected void close() throws BtreeException {
		try {
			_file.close();
		} catch( IOException ioe ) {
			throw new BtreeException(ioe.getMessage());
		}
	}
	/**
	 * B-tree\Ɋ֘AtĂt@CĂ邩ǂԂ
	 * 
	 * @return true:Ă / false:JĂ
	 */
	public boolean isClosed() {
		return _file == null || _file.isClosed();
	}
	/**
	 * VL[𐶐
	 *
	 * @param o IuWFNg
	 * @return BtreeKey i[ĂȂ̃L[
	 * @exception BtreeException Ɏsꍇ
	 */
	protected BtreeKey newKey(Object o) throws BtreeException {
		return _factory.newKey(o);
	}

	/**
	 * f[^}
	 *
	 * @param key L[
	 * @param o IuWFNg
	 * @exception BtreeException
	 */
	protected void insert(BtreeKey key) throws BtreeException, BtreeManipulationException {
		// f[^t@Cɑ΂ď݃bN
		try {
			_lock.beginRead();

			/*
			 * w肳ꂽL[ɂđ}̉\ȃy[WT
		 	 */
			BtreePathTrace trace = findInsertablePage(_file.getRootPageNo(), key, new BtreePathTrace());
			BtreePage insertableTarget = trace.getFound();

			if( insertableTarget == null ) {
				// }\ȃy[W݂ȂꍇCVy[W쐬
				insertableTarget = _file.newPage();
			}

			/*
			 * }
			 */
			BtreePage.PromoResult promo = null;
			long rightChild = -1;
			long originalPageNo = -1;

			// iԂ̓[v
			while((promo = insertableTarget.insert(key,rightChild)) != null) {
				// i̔ɂĕꂽC̃y[ŴR~bgKv
				// ɂăL[Ă邩
				commit(insertableTarget);
	
				originalPageNo = insertableTarget.getPageNo();
				// V쐬ꂽZɑ΂āCVy[Wԍt^ăR~bg
				promo._page.setPageNo(BtreePage.NEW_PAGE);
				commit(promo._page);

				// iL[ɑ΂āCE̎q̃y[Wԍݒ肷
				key = promo._promoKey;
				rightChild = promo._page.getPageNo();
				insertableTarget = trace.pop();
				if(insertableTarget == null) {
					// [g̃y[WɂāCiꍇ͐Vy[W쐬
					// ̍ہC[g̃y[WԍXV
					insertableTarget = _file.newPage();
					insertableTarget.setChildNodeAt(0, originalPageNo);
					_file.replaceRootPageNo(insertableTarget.getPageNo());
				}
			}

			// R~bgKv
			if(insertableTarget != null) {
				commit(insertableTarget);
			}
		} catch(Exception ioe) {
			// o͗ÓCBtreeExceptionɕϊ
			ioe.printStackTrace();
			throw new BtreeException(ioe.getMessage());
		} finally {
			// bN
			try {
				_lock.release();
			} catch(Exception e){}
		}
	}

	/**
	 * f[^폜
	 *
	 * @param key L[
	 */
	protected void delete( BtreeKey key ) throws BtreeException {
	}

	/**
	 * f[^XV
	 *
	 * @param o IuWFNg
	 * @exception BtreeException
	 */
	protected void update(BtreeKey key) throws BtreeException {
	}

	/**
	 * f[^ƃL[̃yA擾
	 *
	 * @param key L[
	 * @return BtreeResultSet ʃZbg
	 * @exception BtreeException
	 */
	protected BtreeResultSet find(BtreeKey key) throws BtreeException {
		BtreeResultSet result = null;

		try {
			_lock.beginRead();
			return findRecursive(_file.getRootPageNo(), key);
			// [gy[W猟
		} catch(BtreeException be) {
			be.printStackTrace();
			throw be;
		} catch(Exception e) {
			e.printStackTrace();
			throw new BtreeException(e.getMessage());
		} finally {
			try {
				_lock.release();
			} catch(Exception ee) {}
		}
	}

	//----- BtreeʃT[rX\bh -----------------------------------------
	/**
	 * w肳ꂽy[WfBXNɏo
	 * @param bp o͑Ώۂ̃y[W
	 * @exception BtreeException 肪
	 */
	protected void commit(BtreePage bp) throws BtreeException {
		if(bp.getPageNo() == BtreePage.NEW_PAGE) {
			// Vy[W\ꂽꍇCy[Ẅ쐬
			// ̔Ԃꂽy[Wԍ擾
			BtreePage newp = _file.newPage();
			bp.setPageNo(newp.getPageNo());
		}
		// y[Ẅ̍XV
if(bp.getPageNo() == 685) {
	System.out.println("685 was created");
}
		_file.replacePage(bp);
	}
	/**
	 * w肳ꂽL[T
	 * L[͕\ɏ]ČC߂l̓oCg񂩂畜ꂽL[̂̂ł
	 * @param root Jny[Wԍ
	 * @param key TL[(\ΕsSł)
	 * @return ꂽSȏԂ̃L[(null: ݂Ȃ)
	 * @throws BtreeException ɉ炩̏Q
	 */
	protected BtreeResultSet findRecursive(long root, BtreeKey key) throws BtreeException {
		// Jny[Ŵ݂Ȃ̂ŃpX
		if(root <= 0) {
			return null;
		}

		BtreePage btp = getPage(root);
		BtreeKey bk = btp.find(key.toString());
		if(bk != null) {
			// ݂
			BtreeResultSet result = new BtreeResultSet();
			result.setKey(bk);
			return result;
		}

		// ̃y[Wɂ݂͑Ȃ悤Ȃ̂ŁC̊KwT
		return findRecursive(btp.getChildPageNo(key), key);
	}
	/**
	 * VL[}邱Ƃ̂ły[WTD
	 * @param root Jny[Wԍ
	 * @param key L[
	 * @param pt pXg[X
	 * @return BtreePathTrace pXg[X
	 */
	protected BtreePathTrace findInsertablePage( long root, BtreeKey key, BtreePathTrace pt ) throws BtreeException {
		// y[Wԍ-1̏ꍇ͏I
		if( root <= 0 ) {
			return pt;
		}

		// w肳ꂽy[W擾āCpXg[XɃy[Wǉ
		BtreePage btp = getPage(root);

		// w肳ꂽy[Wɋ󂫂C̃y[Wɑ}ׂǂ𒲂ׂ
//		if( btp.keyCount() < btp.order() && btp.shouldBeContained(key) == true ) {
		if(btp.shouldBeContained(key) == true) {
			// ɑ}ׂȂ̂ŁC肵ďԂ
			pt.setFound(btp);
			return pt;
		} else {
			// 擾y[WpXg[Xɒǉ
			pt.push(btp);
			// ̃y[W̉̊Kw̃y[Wԍ擾
			long child = btp.getChildPageNo(key);
			// Xɉ̊KwT
			return findInsertablePage(child, key, pt);
		}
	}

	/**
	 * w肳ꂽy[WԂD
	 * w肳ꂽy[WLbVɑ݂ꍇ͂ԂD<br>
	 *
	 * @param pageno y[Wԍ
	 * @return BtreePage Xg[W畜ꂽy[WIuWFNg(null:Ȃ)
	 * @exception BtreeException B-treẽf[^\ꍇɕԂ
	 */
	protected BtreePage getPage( long pageno ) throws BtreeException {
		return getPage( pageno, false );
	}

	/**
	 * w肳ꂽy[WԂD
	 * w肳ꂽy[WLbVɑ݂ꍇ͂ԂD<br>
	 * swaptruȅꍇC\ł΃LbV̏ԂւD<br>
	 * 󂢊Kw̃f[^LbVɓo^悤ɁCԂ̓ւD
	 *
	 * @param pageno y[Wԍ
	 * @param swap true: LbV̓ւ false: ւȂ
	 * @return BtreePage Xg[W畜ꂽy[WIuWFNg(null:Ȃ)
	 * @exception BtreeException B-treẽf[^\ꍇɕԂ
	 */
	protected BtreePage getPage( long pageno, boolean swap ) throws BtreeException {
		if(swap) {
		}
		return _file.getPage(pageno);
	}

	/**
	 * BtreěpXg[XۊǂNX
	 * @author satoshi akabane
	 * @version 1.0
	 */
	protected class BtreePathTrace {
		private final Stack pathStack;			// pX
		private BtreePage foundPage = null;		// ړĨy[W

		/**
	 	 * RXgN^
		 */
		protected BtreePathTrace() {
			pathStack = new Stack();
		}
		/**
		 * TpXɑ΂ăy[Wǉ
		 * @param bp ǉy[W
		 */
		protected void push( BtreePage bp ) {
			pathStack.push(bp);
		}
		/**
		 * pX̍Ōォ1o
		 * @return BtreePage oy[W
		 */
		protected BtreePage pop() {
			return pathStack.empty() == false ? (BtreePage)pathStack.pop() : null;
		}
		/**
		 * TĂy[Wݒ肷
		 * @param bp y[W
		 */
		protected void setFound( BtreePage bp ) {
			foundPage = bp;
		}
		/**
		 * TĂy[WԂ
		 * @return BtreePage y[W(null:ǂȂ)
		 */
		protected BtreePage getFound() {
			return foundPage;
		}
		/**
		 * X^bN󂩂ǂԂ
		 * @return boolean true:  / false: Ă
		 */
		protected boolean isEmpty() {
			return pathStack.empty();
		}
		/**
		 * pXg[XSɏ
		 */
		protected void clear() {
			synchronized(pathStack) {
				while(pathStack.empty() == false) {
					pathStack.pop();
				}
			}
		}
	}
}

// end of Btree.java
