/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.util.StringUtils;

/**
 * `\ȃN^OBtreeKey
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class DrawableBtreeKey extends BtreeKey implements Drawable {
	public static final int KEY_BYTE_SIZE = 16;
	protected Rectangle rectangle;
	protected String _key;

	/**
	 * oCgXg[L[𕜌^CṽRXgN^
	 * @param bstream oCgXg[
	 * @throws BtreeException oCgXg[L[̕łȂ
	 */
	public DrawableBtreeKey(byte[] bstream) throws BtreeException {
		super(bstream);
	}
	/**
	 * IuWFNgL[𕜌RXgN^
	 * @param o IuWFNg
	 * @throws BtreeException w肳ꂽIuWFNgL[𕜌łȂ
	 */
	public DrawableBtreeKey(Object o) throws BtreeException {
		super(o);
	}
	/**
	 * IuWFNgBtreeKey̎̂𐶐D<br>
	 * ̃\bh͌JȂDʏ<br>
	 * public void objectToBtreeKey(String str)<br>
	 * ̂قgp
	 * @param o IuWFNg
	 * @throws BtreeException ̉Ɏs
	 */
	protected void objectToBtreeKey(Object o) throws BtreeException {
		if(o instanceof java.lang.String == false) {
			throw new BtreeException("IuWFNgjava.lang.StrinĝݗLł");
		}
		_key = (String)o;
	}

	/**
	 * IuWFNgBtreeKey̎̂𐶐D<br>
	 * ̃\bh͌JȂDʏ<br>
	 * public void objectToBtreeKey(String str)<br>
	 * ̂قgp
	 * @param o IuWFNg
	 * @throws BtreeException ̉Ɏs
	 */
	protected void byteStreamToBtreeKey(byte[] bstream) throws BtreeException {
		_key = new String(bstream).trim();
	}

	/**
	 * L[̕`ԂD
	 * @return String L[̕`
	 */
	public String toString() {
		return _key;
	}

	/**
	 * L[rD
	 * @param obj rΏ
	 * @return boolean true: ł / false: Ⴄ
	 */
	public boolean equals(Object obj) {
		return _key.equals(obj.toString());
	}

	/**
	 * w肳ꂽL[菬ǂԂ
	 * @param key rΏ
	 * @return boolean true: this < key / false: this >= key
	 */
	public boolean isLessThan(BtreeKey key) {
		return _key.compareTo(key.toString()) < 0;
	}

	/**
	 * w肳ꂽL[傫ǂԂ
	 * @param key rΏ
	 * @return boolean true: this > key / false: this <= key
	 */
	public boolean isGreaterThan(BtreeKey key) {
		return _key.compareTo(key.toString()) > 0;
	}

	/**
	 * oCg񂩂BtreeKey̎̂𐶐D
	 * @param bstream oCg
	 * @exception BtreeException
	 */
	public byte[] byteStream() {
		byte[] bytearray = new byte[KEY_BYTE_SIZE];
		byte[] thiskey = _key.getBytes();
		
		System.arraycopy(thiskey, 0, bytearray, 0, thiskey.length);
		return bytearray;
	}

	/**
	 * IuWFNg̕`惁\bh
	 * @param g `Ώۂ̃r[
	 * @param position `Jnʒu(N^O̍̒_̍W)
	 */
	public void draw(Graphics g, Point position) {
		int width = getSize().width;
		int height = getSize().height;

		// ֊s`		
		g.setColor(Color.ORANGE);
		g.fillRect(position.x, position.y, width, height);
		g.setColor(Color.BLACK);
		g.drawRect(position.x, position.y, width, height);

		// `
		FontMetrics metrics = BtreeSimulatorMainPanel.getFontMetrics();
		g.drawString(StringUtils.trimControlChars(_key.trim()), position.x +2, position.y + metrics.getAscent() +2);
	}
	/**
	 * ̃IuWFNg̕`ɕKvȃTCY(px)Ԃ
	 * @return `ɕKvȃsNZTCY
	 */
	public Dimension getSize() {
		// ݐݒ肳ĂtHggbN擾
		FontMetrics metrics = BtreeSimulatorMainPanel.getFontMetrics();
		char[] keychars = StringUtils.trimControlChars(_key.trim()).toCharArray();
		int width = metrics.charsWidth(keychars, 0, keychars.length);
		int height = metrics.getHeight();

		return new Dimension(width + 4, height + 4);
	}
}
