/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.util.Properties;

import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.OnMemoryBtreeFragmentFile;

/**
 * B-treeV~[^p̃t@NgNX
 * `\BtreeKeyCBtreePageȂǂ𐶐
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class DrawableBtreeFactory extends BtreeFactory {
	private static BtreeKey _key = null;
	protected static Properties _prop = null;

	static {
		// ̃t@NgŐL[CIuWFNgуt@C̐ݒl̏
		_prop = new Properties();
		_prop.setProperty(BtreeFile.MAGIC_NUMBER, "DBTP");
		_prop.setProperty(BtreeFile.MAJOR_VERSION, "1");
		_prop.setProperty(BtreeFile.MINOR_VERSION, "0");
		_prop.setProperty(BtreeFile.HEADER_SIZE, "128");
		_prop.setProperty(BtreeFile.ORDER, "5");
		_prop.setProperty(BtreeFile.KEYSIZE, Integer.toString(DrawableBtreeKey.KEY_BYTE_SIZE));
	}

	/**
	 * ̃t@NgŐt@C̐ݒlԂ
	 * 
	 * @return ݒl
	 * @throws BtreeException ݒlԂƂłȂꍇ
	 */
	public Properties getProperty() throws BtreeException {
		return _prop;
	}

	/**
	 * t@CnhԂ<br>
	 * ̃\bhĂяoĂCt@Ĉ̓I[vĂȂƂɒ
	 * 
	 * @param filename t@C
	 * @return BtreeFile t@C
	 * @throws BtreeException 炩̗RŃt@Cnh̐Ɏs
	 */
	public BtreeFile getFileHandle(String filename) throws BtreeException {
		Properties prop = (Properties)getProperty().clone();
		prop.setProperty(BtreeFile.FILENAME, filename);

		return new BTSBtreeFile(this, prop);
	}

	/**
	 * VL[𐶐ĕԂ
	 * @param o IuWFNg
	 * @return VꂽL[
	 * @throws BtreeException IuWFNg̕Ɏs
	 */
	public BtreeKey newKey(Object o) throws BtreeException {
		return new DrawableBtreeKey(o);
	}

	/**
	 * VL[𐶐ĕԂ
	 * @param stream oCgXg[
	 * @return VꂽL[
	 * @throws BtreeException oCgXg[̕Ɏs
	 */
	public BtreeKey newKey(byte[] stream) throws BtreeException {
		return new DrawableBtreeKey(stream);
	}

	/**
	 * BtreeKeỹoCgTCYԂ
	 *
	 * @return int oCgTCY
	 * @see org.logical_paradox.common.btree.BtreeKey
	 */
	public int keyByteSize() {
		return DrawableBtreeKey.KEY_BYTE_SIZE;
	}

	/**
	 * p\XgԂ
	 * C쐬ꂽp\Xg̓I[vȂ
	 * @param filename t@C
	 * @return p\Xg
	 * @throws BtreeException p\Xg̍쐬Ɏs
	 */
	public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
		return new OnMemoryBtreeFragmentFile();
	}
}
