/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.btree.BtreeSession;

/**
 * B-tree̐}ʏǗNX
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class Diagram {
	private final static int POINTER_WIDTH = 4;
	private final BtreeSimulatorMainPanel mainPanel;
	private BtreeSession session;

	/**
	 * RXgN^
	 * @param panel Cpl
	 */
	public Diagram(BtreeSimulatorMainPanel panel) throws Exception {
		mainPanel= panel;

		// VB-tree\𐶐CZbV𐶐
		session = Btree.getInstance(new DrawableBtreeFactory()).getSession();
		session.open("");
	}
	/**
	 * VL[c[ɑ}
	 * @param key L[
	 * @throws BtreeException Ɏs
	 */
	public void insert(String key) throws Exception {
		session.insert(new DrawableBtreeKey(key));
		repaint();
	}
	/**
	 * w肳ꂽL[CVL[ōXV
	 * @param src ̃L[ 
	 * @param dest XṼL[
	 * @throws BtreeException Ɏs
	 */
	public void update(String src, String dest) throws Exception {
		repaint();
	}
	/**
	 * w肳ꂽL[c[珜
	 * @param key
	 * @throws BtreeException
	 */
	public void delete(String key) throws Exception {
		repaint();
	}
	
	/**
	 * ̃AvP[VƊ֘AtĂr[ɑ΂āCc[}̍ĕ`w
	 */
	public void repaint() {
		paint(mainPanel.getGraphics());
	}
	/**
	 * ̐}ʂ`悷D
	 * Cplĕ`̃^C~OŁC(1)LoX (2)̃\bh ̏ŌĂяo
	 * @param g `Ώۂ̃OtBbN[W
	 * @see BtreeSimulatorMainPanel
	 */
	public void paint(Graphics g) {
		g.setColor(Color.BLACK);
		// [g̃y[W`Jn
		try {
			drawPage(g, session.getPage(), 0, 20);
		} catch (BtreeException e) {
			// G[ł̂ŃOo
			System.out.println("y[W`撆ɉ炩̗Oł");
			e.printStackTrace();
		}
	}
	/**
	 * w肳ꂽy[WLoXɕ`悷
	 * ̃\bh̓c[ʂȂŜ`悷
	 * @param g `̃r[
	 * @param level ݂̃m[h̐[
	 * @param btp `悷y[W
	 */
	protected int drawPage(Graphics g, BtreePage btp, int level, int xoffset) {
		if(btp == null) {
			return 0;
		}
		// SĂ̎qm[hɂă[v
		BtreeKey[] keys = btp.getKeys();
		BtreePage childNode = null;

		int startx = xoffset;
		int childrenWidth = 0;
		for(int i = 0; i < btp.keyCount() +1; i++) {
			try {
				long childpageno = btp.getChildNodeAt(i);
				if(childpageno > 0) {
					// qm[h̃y[Wԍ擾ĕ`
					childNode = session.getPage(childpageno);
					int pagewidth = drawPage(g, childNode, level+1, startx + childrenWidth);	// y[WԂ20px󂯂
					childrenWidth += pagewidth + 10;
				}
			} catch(Exception be) {
				be.printStackTrace();
			}
		}
		int pageoffset = (childrenWidth - calcPageWidth(btp)) /2;
		if(childrenWidth == 0) {
			pageoffset = 0;
		}
System.out.println("childr=" + childrenWidth);
System.out.println("pagewd=" + calcPageWidth(btp));
System.out.println("startx=" + startx);
System.out.println("poffst=" + pageoffset);

		return drawKeys(g, btp, level, startx + pageoffset);
	}
	/**
	 * y[W̕`TCYvZĕԂ
	 * @param btp `Ώۂ̃y[W
	 * @return y[W̃TCY(px)
	 */
	protected int calcPageWidth(BtreePage btp) {
		BtreeKey[] keys = btp.getKeys();

		// `ɕKvȃTCY̌vZ
		int width = 0;
		int height = 0;

		for(int i = 0; i < btp.keyCount(); i++) {
			DrawableBtreeKey drawable = (DrawableBtreeKey)keys[i];
			Dimension d = drawable.getSize(); 
			width += d.width;
			if(height < d.height) {
				height = d.height;
			}

			// qm[h̃|C^̃TCYǉ
			// POINTER_WIDTHpxƂ
			width += POINTER_WIDTH;
		}
		if(keys.length > 0) {
			width += POINTER_WIDTH;		// őL[̉Ẽm[h\
		}

		return width;
	}
	/**
	 * y[W̓eSĕ`悷
	 * @param g `̃r[
	 * @param level ݂̃m[h̐[
	 * @param btp `悷y[W
	 */
	protected int drawKeys(Graphics g, BtreePage btp, int level, int xoffset) {
		BtreeKey[] keys = btp.getKeys();
System.out.println("xoffset=" + xoffset);
		// `ɕKvȃTCY̌vZ
		int width = calcPageWidth(btp);
		int height = 0;

		if(keys[0] != null) {
			height = ((DrawableBtreeKey)keys[0]).getSize().height;
		}

		// `Jn钆SʒuvZ
		int startx = xoffset; //(mainPanel.getCanvasSize().width - width) /2;
		int starty = 48 + level * (height + 16);

		// SẴL[ƃ|C^`悷
		for(int cnt = 0; cnt < btp.keyCount(); cnt++) {
			// |C^̕`
			g.drawRect(startx, starty, POINTER_WIDTH, height);
			startx += POINTER_WIDTH;

			// L[̕`
			DrawableBtreeKey dbk = (DrawableBtreeKey)keys[cnt];
			dbk.draw(g, new Point(startx, starty));
			startx += dbk.getSize().width;
		}

		// ԉẼ|C^`
		g.drawRect(startx, starty, POINTER_WIDTH, height);
		startx += POINTER_WIDTH;

		return width;
	}
}
