/**
 * LOGICAL-PARADOX.ORG b-tree library
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 * Release 1.0
 * Ep[W
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

/**
 * B-treeV~[^̃CplD
 * ̃plapplet/java application̗gpD
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class BtreeSimulatorMainPanel extends JPanel {
	private Diagram diagram;
	private static FontMetrics metrics;
	protected DiagramCanvas canvas;
	protected JTextField keyInputField;
	protected JButton btnAdd;
	protected JButton btnRemove;
	protected JButton btnChange;
	protected BTSEventHandler handler;

	/**
	 * ftHgRXgN^
	 */
	public BtreeSimulatorMainPanel() throws Exception {
		init();
	}
	/**
	 * _CAOԂ
	 * @return _CAO
	 */
	public Diagram getDiagram() {
		return diagram;
	}
	/**
	 * LoX̃TCYԂ
	 * @return LoX̃TCY
	 */
	public Dimension getCanvasSize() {
		return canvas.getPreferredSize();
	}
	/**
	 * tHggbNXԂ
	 * ̃\bh͎DrawableBtreeKeyĂяo
	 * @return gbN
	 */
	public static FontMetrics getFontMetrics() {
		return metrics;
	}
	/**
	 * ̃pl̏D
	 * ł͕KvȃR|[lg̔zus邪C\͍sȂ
	 */
	public void init() throws Exception {
		// }ʃNX̍쐬
		diagram = new Diagram(this);

		// Cxgnh̍쐬
		handler = new BTSEventHandler(this);

		// LoX̍쐬
		canvas = new DiagramCanvas();

		// ʏ㕔̃Rg[pl쐬
		JPanel controlPanel = new JPanel();
		JPanel buttonPanel = new JPanel();
		
		// Rg[plɔzu镔i𐶐
		keyInputField = new JTextField();
		keyInputField.addActionListener(handler);

		btnAdd = new JButton("ǉ");
		btnRemove = new JButton("폜");
		btnChange = new JButton("ύX");
		btnAdd.addActionListener(handler);
		btnRemove.addActionListener(handler);
		btnChange.addActionListener(handler);

		// Rg[plɕizu
		buttonPanel.setLayout(new GridLayout(1, 3));
		buttonPanel.add(btnAdd);
		buttonPanel.add(btnChange);
		buttonPanel.add(btnRemove);

		controlPanel.setLayout(new BorderLayout());
		controlPanel.add(keyInputField, BorderLayout.CENTER);
		controlPanel.add(buttonPanel, BorderLayout.EAST);
		controlPanel.add(new JLabel("  key    "), BorderLayout.WEST);
		controlPanel.add(new JSeparator(), BorderLayout.SOUTH);

		// CplɃLoXƃRg[plzu
		setLayout(new BorderLayout());
		add(canvas, BorderLayout.CENTER);
		add(controlPanel, BorderLayout.NORTH);

		validate();
	}
	/**
	 * eLXg͗Ԃ
	 * @return eLXg͗̃CX^X
	 */
	public JTextField getTextField() {
		return keyInputField;
	}
	/**
	 * ǉ{^Ԃ
	 * @return {^̃CX^X
	 */
	public JButton getAddButton() {
		return btnAdd;
	}
	/**
	 * 폜{^Ԃ
	 * @return {^̃CX^X
	 */
	public JButton getRemoveButton() {
		return btnRemove;
	}
	/**
	 * ύX{^Ԃ
	 * @return {^̃CX^X
	 */
	public JButton getChangeButton() {
		return btnChange;
	}
	/**
	 * ̃pl`悷
	 * `揇dvł邽߁CI[o[Chĕ`揇wD
	 * @param g `Ώۂ̃OtBbN[W
	 */
	public void paint(Graphics g) {
		super.paint(g);

		// tHg̐ݒ
		g.setFont(new Font("SanSelif", 0, 10));
		metrics = g.getFontMetrics();

		diagram.paint(g);
	}

}
