/**
 * I18nProperties
 * ۉΉPropertiesNX
 */
package org.logical_paradox.rss.util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;

public class I18nProperties extends Properties {
	public I18nProperties() {
		super();
	}

	public I18nProperties( Properties defaults ) {
		super( defaults );
	}

	public void load( InputStream in ) throws IOException {
		super.load( in );

		Enumeration e = propertyNames();
		while( e.hasMoreElements() ) {
			String keyname = (String)e.nextElement();
			String o = (String)get( keyname );
			byte[] buf = o.getBytes( "8859_1" );

			BufferedReader br = new BufferedReader( new InputStreamReader( new ByteArrayInputStream( buf ), "JISAutoDetect" ) );

			StringBuffer sb = new StringBuffer();
			String lineBuffer = null;
			while( (lineBuffer = br.readLine()) != null ) {
				if( sb.toString().length() > 0 ) {
					sb.append( "\n" );
				}
				sb.append( lineBuffer );
			}
			setProperty( keyname, sb.toString() );
		}
	}
}

// end of I18nProperties.java
