/*
 * DelayedSyncTestGUI
 * xeXĝ߂GUINCAg
 */
package org.logical_paradox.rss.test.dsync;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.TooManyListenersException;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.logical_paradox.rss.dsync.RSSSyncDaemon;
import org.logical_paradox.rss.logging.RSSLogWriter;

public class DelayedSyncTestGUI extends JFrame {
	public static final int PANEL_WIDTH = 200;
	public static final int PANEL_HEIGHT = 150;

	RSSSyncDaemon syncd;
	String windowTitle;
	JTextField tf;
	JButton sendBtn;
	JButton cancelBtn;
	JButton syncBtn;
	JComboBox commandListBox;
	JTextArea commLogPane;
	JList commandQueueList;
	RSSLogWriter logger;

	Vector commandQueue = new Vector();

	public DelayedSyncTestGUI( String ttl, RSSSyncDaemon d ) {
		windowTitle = ttl;
		syncd = d;
	}

	public void initApplication() {
		// ei̐
		tf = new JTextField( 40 );
		tf.addActionListener( new SendButtonActionCallback( this ) );
		sendBtn = new JButton( "OK" );
		sendBtn.addActionListener( new SendButtonActionCallback( this ) );
		cancelBtn = new JButton( "cancel" );
		cancelBtn.addActionListener( new CancelButtonActionCallback( this ) );
		syncBtn = new JButton( "sync" );
		syncBtn.addActionListener( new SyncButtonActionCallback( this ) );

		commandListBox = new JComboBox();
		commandListBox.addItem( new String( "LOCK" ) );
		commandListBox.addItem( new String( "UNLOCK" ) );
		commandListBox.addItem( new String( "FORWARD_URL" ) );
		commandListBox.addItem( new String( "UNFORWARD_URL" ) );

		commLogPane = new JTextArea();
//		commLogPane.setPreferredSize( new Dimension( PANEL_WIDTH, PANEL_HEIGHT ) );
		commLogPane.setEditable( false );
//		commLogPane.setLineWrap( true );

		JPanel mainPanel = new JPanel( new BorderLayout() );
		JPanel btnPanel = new JPanel( new BorderLayout() );
		btnPanel.add( commandListBox, BorderLayout.CENTER );
		btnPanel.add( sendBtn, BorderLayout.EAST );

		mainPanel.add( tf, BorderLayout.NORTH );
		mainPanel.add( new JScrollPane(commLogPane), BorderLayout.CENTER );
		mainPanel.add( btnPanel, BorderLayout.EAST );

		JPanel menuPanel = new JPanel( new BorderLayout() );
		commandQueueList = new JList();
		menuPanel.add( new JScrollPane(commandQueueList), BorderLayout.CENTER );
		menuPanel.add( btnPanel, BorderLayout.NORTH );
		JPanel listActionBtnPanel = new JPanel( new GridLayout( 1, 2 ) );
		listActionBtnPanel.add( syncBtn );
		listActionBtnPanel.add( cancelBtn );
		menuPanel.add( listActionBtnPanel, BorderLayout.SOUTH );

		getContentPane().setLayout( new BorderLayout() );
		getContentPane().add( mainPanel, BorderLayout.CENTER );
		getContentPane().add( menuPanel, BorderLayout.EAST );
		validate();
		pack();

		Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation( ((int)windowLocation.getWidth() - getWidth()) /2, ((int)windowLocation.getHeight() - getHeight()) /2 );

		setVisible( true );

		setTitle( windowTitle );

		logger = new DelayedSyncLogWriter( new JTextComponentOutputStream( commLogPane ) );
		syncd.setLogWriter( logger );
		try {
			syncd.addListener( new TestDelayedSyncEventListener( logger ) );
		} catch( TooManyListenersException tmle ) {
			System.err.println( "Xi[܂˂" );
		}
	}

}

// end of DelayedSyncTestGUI.java
