/*
 * DelayedSyncTest
 * x̃eXg
 * ̃eXgc[gpɂ́CL̃T[rXJnĂKv
 *
 * EoHm[hIq
 * EoHm[hNCAgq
 */
package org.logical_paradox.rss.test.dsync;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;

import org.logical_paradox.rss.dsync.RSSSyncDaemon;
import org.logical_paradox.rss.router.RSSRoutingNodeSelector;
import org.logical_paradox.rss.router.RoutingNodeClient;

public class DelayedSyncTest {
	public static final String DELAYED_SYNC_TEST_CONFIG = "conf/test/dsync/dsynctest.conf";

	RSSRoutingNodeSelector selector;
	DelayedSyncConfig config;
	RSSSyncDaemon syncd;
	String nodeKey;

	/*
	 * ftHgRXgN^
	 */
	public DelayedSyncTest() throws Exception {
		config = new DelayedSyncConfig( DELAYED_SYNC_TEST_CONFIG );
		selector = (RSSRoutingNodeSelector)Naming.lookup( config.getSelectorNodeName() );
		RoutingNodeClient client = (RoutingNodeClient)selector.bindSearchNode();
		nodeKey = client.getNodeId();
		syncd = new RSSSyncDaemon( config, client );
	}

	public void doTest() {
		syncd.start();
	}

	/*
	 * C\bh
	 */
	public static void main( String[] args ) throws Exception {
		final DelayedSyncTest tester = new DelayedSyncTest();

		DelayedSyncTestGUI mainWnd = new DelayedSyncTestGUI( "RSS/1b delayed sync mechanism test client", tester.syncd );
		mainWnd.addWindowListener( new WindowAdapter() {
					public void windowClosing( WindowEvent we ) {
						try {
							tester.selector.unbindSearchNode( tester.nodeKey );
							tester.syncd.shutdown();
						} catch( Exception e ) {
							e.printStackTrace();
						}
						System.exit(0);
					}
			}
		);

		mainWnd.initApplication();
		mainWnd.repaint();

		tester.doTest();
	}
}

// end of DelayedSyncTest.java
