/**
 * LBRoutingAlgorithm
 * TCgT̂߂̕וUTASY
 */
package org.logical_paradox.rss.router.algorithm;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;

import org.logical_paradox.rss.http.URLPool;

public class LBRoutingAlgorithm extends RoutingAlgorithm {
	public static final int REQ_DOMAINS_PER_TIME = 20;			// xɃv[擾hC̑
	public static final int HISTORY_PRIO_BUFSIZE = 20;			// וUpqXg̃TCY

	private URLHistoryPrio prio = null;
	private int lastRefIdx = 0;

	public LBRoutingAlgorithm() {
		super();
		prio = new URLHistoryPrio( REQ_DOMAINS_PER_TIME );
	}

	// ̃\bh邱
	/**
	 * ASŶ̖Ԃ
	 */
	public String getAlgorithmName() {
		return "Load Balanced Routing Algorithm";
	}

	/**
	 * 1肷邽߂̃ASY()
	 */
	public String nextURL( URLPool urls ) {
		String rc = null;

//		synchronized( urls ) {
			boolean exitf = true;
			do {
				if( urls.size() == 0 ) {
					// Ȃ
					rc = null;
					exitf = false;
				} else {
					// URL̃v[URL1擾
					String dn = getNextSite( urls );
					Iterator i = urls.getURLIterator( dn );
					if( i == null ) {
						return null;
					}
					rc = (String)i.next();
					try {
						urls.remove( rc );
					} catch( MalformedURLException e ) {
					}

					if( history.isTraced( rc ) == false ) {
						// ܂g[XĂȂURLꍇ
						// Tɒǉ
						history.add( rc );
						exitf = false;
					}
				}
			} while( exitf == true );
//		}

		return rc;
	}

	/**
	 * ɒTׂTCgԂ
	 */
	private String getNextSite( URLPool urls ) {
		String rc = null;

		String[] domains = urls.domains();
		if( domains == null ) {
			return null;
		}

		int looptime = domains.length >= REQ_DOMAINS_PER_TIME ? REQ_DOMAINS_PER_TIME : domains.length;
		int idx = lastRefIdx;
		int highscore = REQ_DOMAINS_PER_TIME + 1;

		int priority = 0;

		for( int i = 0; i < looptime; i++ ) {
			if( idx >= domains.length ) {
				idx = 0;
			}
			String dn = domains[ idx ];
			priority = prio.indexOf( dn );
			if( priority <= highscore ) {
				highscore = priority;
				rc = dn;
			}
			// D揇-1̏ꍇ͂ŏIĂ܂OK
			if( priority == -1 ) {
				break;
			}

			idx++;
		}

		if( rc != null ) {
			// oǗIuWFNgɁCIꂽ̂o^
			lastRefIdx = idx;
			prio.addFirst( rc );
		}
		return rc;
	}

	/**
	 * hCoԂǗNX
	 * indexOobt@
	 */
	class URLHistoryPrio {
		private LinkedList buf = null;				// obt@
		private int bufsize = 0;					// obt@̃TCY

		// RXgN^
		private URLHistoryPrio( int size ) {
			buf = new LinkedList();
			bufsize = size;
		}

		// ǉ
		// ǉƓɁCKvȂȂ̂ɂĂ̓Xg폜
		private void addFirst( String url ) {
			synchronized( buf ) {
				int idx = indexOf( url );
				if( idx >= 0 ) {
					// ɓURL݂ꍇ́C폜
					buf.remove( url );
				} else if( buf.size() >= bufsize ) {
					// wURL݂Cobt@̃TCYς̏ꍇ́CԍŌ̂̂폜
					buf.removeLast();
				}
				// Xg̍Ōɍ^ꂽURLǉ
				buf.addLast( url );
			}
		}

		// wURL܂܂ĂʒuԂ
		// ܂܂ĂȂꍇ-1
		private int indexOf( String url ) {
			return buf.indexOf( url );
		}
	}
}

// end of LBRoutingAlgorithm.java
