/**
 * RSSRoutingNodeSelectorImpl
 * oHm[hIq()
 */
package org.logical_paradox.rss.router;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModuleIF;
import org.logical_paradox.rss.logging.RSSRNSLogWriter;

public class RSSRoutingNodeSelectorImpl extends UnicastRemoteObject implements RSSRoutingNodeSelector,RSSSubModuleIF {
	public final static String RSS_ROUTE_SELECTOR_CONF_PATH = "conf/rssrouteselector.conf";

	private Hashtable routingNodes = null;				// oHm[h̃Xg
	private RSSRoutingNodeSelectorConfig cfg = null;	// oHm[hIq̃RtBO
	private RSSRNSLogWriter logger = null;				// oHm[hIq̃OC^[
	
	/**
	 * RXgN^
	 */
	public RSSRoutingNodeSelectorImpl() throws RemoteException {
		routingNodes = new Hashtable();
	}

	/**
	 * Tm[hoCh
	 * ߂lƂāCۂɃoChꂽoHm[hNCAg̃X^uԂ
	 */
	public RoutingNodeClient bindSearchNode() throws RemoteException {
		logger.write( "Tm[h̎󂯓TĂ܂" );

		// łڑNCAg(Tm[h)̏ȂoHm[hI
		Enumeration e = routingNodes.keys();
		RoutingNodeContainer selected = null;

		int clientsOfTheSelected = -1;

		String containerKey = null;

		while( e.hasMoreElements() ) {
			String key = (String)e.nextElement();
			RoutingNodeContainer c = (RoutingNodeContainer)routingNodes.get( key );
			if( c != null && (clientsOfTheSelected < 0 || c.getClients() < clientsOfTheSelected) ) {
				clientsOfTheSelected = c.getClients();
				selected = c;
				containerKey = key;
			}
		}

		if( selected == null ) {
			logger.write( "󂯓̌oHm[hNCAg邱Ƃł܂ł" );
			throw new RemoteException();
		}

		// IꂽoHm[h(̃t@Ng)ɑ΂āCoHm[hNCAgւ̃oChv
		RoutingNodeClient rm = selected.bindSearchNode();
		try {
			logger.write( "Tm[h'" + rm.getNodeId() +"'oHm[h'" + selected.getServerName() + "'փoCh܂" );
		} catch( Exception ex ) {
			throw new RemoteException( ex.getMessage() );
		}
		return rm;
	}

	/**
	 * Tm[h؂藣
	 */
	public void unbindSearchNode( String robotId ) throws RemoteException {
		logger.write( "Tm[h'" + robotId + "'؂藣Ă܂" );

		// o^ĂSĂ̌oHm[hNCAgt@Ngɑ΂āC폜v𔭍s
		// ǂꂩK폜{͂
		Enumeration e = routingNodes.elements();
		boolean exitf = true;
		while( e.hasMoreElements() && exitf ) {
			RoutingNodeContainer c = (RoutingNodeContainer)e.nextElement();
			if( c.removeClient( robotId ) ) {
				logger.write( "Tm[h'" + robotId + "'CoHm[h'" + c.getServerName() + "'؂藣܂" );
				exitf = false;
			}
		}
	}

	/**
	 * oHm[hNCAg̃t@NgoCh
	 */
	public void bindRoutingNode( String sn, RNodeClientFactory f ) throws RemoteException {
		logger.write( "oHm[h'" + sn + "'oChĂ܂" );

		RoutingNodeContainer c = new RoutingNodeContainer( sn, f );
		routingNodes.put( sn, c );

		logger.write( "oHm[h'" + sn + "'oCh܂" );
	}

	/**
	 * oHm[hNCAg̃t@Ng؂藣
	 */
	public void unbindRoutingNode( String rnId ) throws RemoteException {
		logger.write( "oHm[h'" + rnId + "'oChĂ܂" );

		if( routingNodes.remove( rnId ) == null ) {
			logger.write( "oHm[h'" + rnId + "'Ȃ̂ŁC؂藣܂ł" );
		} else {
			logger.write( "oHm[h'" + rnId + "'؂藣܂" );
		}
	}


	/**
	 * T[rXCĂt@Ng̈ꗗԂ
	 */
	public String[] getFactories() throws RemoteException {
		Vector names = new Vector();

		synchronized( routingNodes ) {
			Enumeration e = routingNodes.keys();
			while( e.hasMoreElements() ) {
				names.addElement( e.nextElement() );
			}
		}

		return (String[])names.toArray( new String[1] );
	}

	/*
	 * T[rXCĂSẴt@Ng
	 */
	public void unbindAll() throws RemoteException {
		logger.write( "T[rXCĂSĂ̌oHm[hNCAgqĂ܂" );
		String[] factories = getFactories();
		for( int i = 0; i < factories.length; i++ ) {
			try {
				Naming.unbind( factories[i] );
				logger.write( "T[rXCĂSĂ̌oHm[hNCAgqĂ܂" );
			} catch( Exception nbe ) {}
		}
		logger.write( factories.length + "̌oHm[hNCAgq܂" );
	}

	/**
	 * t@Ng̃X^uԂ
	 */
	public RNodeClientFactory getFactoryStub( String fn ) throws RemoteException {
		return ((RoutingNodeContainer)routingNodes.get( fn )).getFactory();
	}

	/**
	 * T[o[Np\bh
	 */
	public static void main( String[] args ) {
		try {
			RSSRoutingNodeSelectorImpl selector = new RSSRoutingNodeSelectorImpl();
			selector.startModule();
		} catch( Exception e ) {
			System.err.println( e.getMessage() );
			e.printStackTrace();
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			// ݒt@C̓ǂݍ݂Ɠě
			cfg = new RSSRoutingNodeSelectorConfig( RSSRoutingNodeSelectorImpl.RSS_ROUTE_SELECTOR_CONF_PATH );
			logger = new RSSRNSLogWriter( new FileOutputStream( "logs" + File.separator + cfg.getSelectorRunLogFilename(), true ) );

			logger.setLoggingMode( cfg.getSelectorSwRunLog() );
			logger.write( "OC^[܂" );

			String selectorServiceName = cfg.getRSSRoutingNodeSelector();
			Naming.rebind( selectorServiceName, this );
			System.err.println( "RoutingNodeSelector '" + selectorServiceName + "' is started" );

			logger.write( "oHm[hIT[rX'" + selectorServiceName + "'Jn܂" );

		} catch( Exception e ) {
			throw new ModuleException( e );
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}


	/**
	 * oHm[hǗ邽߂̓ꕨ
	 */
	class RoutingNodeContainer {
		private String serverName = null;				// oHm[h
		private LinkedList clients = null;				// oHm[hŊǗĂTm[h(Xg)
		private RNodeClientFactory factory = null;		// t@NgT[rX̃X^u

		private RoutingNodeContainer( String sn, RNodeClientFactory f ) {
			serverName = new String( sn );
			factory = f;
			clients = new LinkedList();
		}
		private String getServerName() {
			return new String( serverName );
		}
		private int getClients() {
			return clients.size();
		}
		private boolean removeClient( String robotId ) throws RemoteException {
			boolean rc = clients.remove( robotId );
			if( rc == true ) {
				// w肳ꂽTm[hCꗗ폜łꍇ
				// t@Ngɍ폜v𔭍s
				getFactory().unbindSearchNode( robotId );
			}

			return rc;
		}
		private RNodeClientFactory getFactory() {
			return factory;
		}
		private RoutingNodeClient bindSearchNode() throws RemoteException {
			RoutingNodeClient rn = getFactory().bindSearchNode();
			try {
				clients.add( rn.getNodeId() );
			} catch( Exception e ) {
				throw new RemoteException( e.getMessage() );
			}
			return rn;
		}
	}
}

// end of RSSRoutingNodeSelectorImpl.java
