/**
 * RSSRoutingNodeSelectorConfig
 * RSS oHVXeIqݒēNX
 */
package org.logical_paradox.rss.router;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public class RSSRoutingNodeSelectorConfig extends RSSConfig {
	private String cfgRSSRoutingNodeSelector = "route_selector";
	private boolean cfgSelectorSwDebugTraceLog = false;
	private boolean cfgSelectorSwRunLog = false;
	private String cfgDebugTraceLogFilename = "rss.selector.trace.log";
	private String cfgSelectorRunLogFilename = "rss.selector.run.log";


	public RSSRoutingNodeSelectorConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	public String getRSSRoutingNodeSelector() {
		return cfgRSSRoutingNodeSelector;
	}
	public boolean getSelectorSwDebugTraceLog() {
		return cfgSelectorSwDebugTraceLog;
	}
	public boolean getSelectorSwRunLog() {
		return cfgSelectorSwRunLog;
	}
	public String getDebugTraceLogFilename() {
		return cfgDebugTraceLogFilename;
	}
	public String getSelectorRunLogFilename() {
		return cfgSelectorRunLogFilename;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		if( getProperty( "RSS_ROUTING_NODE_SELECTOR" ) != null ) {
			cfgRSSRoutingNodeSelector = getProperty( "RSS_ROUTING_NODE_SELECTOR" );
		}

		try {
			cfgSelectorSwDebugTraceLog = getPropertyAsBool( "SELECTOR_SW_DEBUG_TRACE_LOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "SELECTOR_SW_DEBUG_TRACE_LOGsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgSelectorSwRunLog = getPropertyAsBool( "SELECTOR_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "SELECTOR_SW_RUNLOGsł\n";
		} catch( RSSNullValueException ne ) {}

		if( getProperty( "DEBUG_TRACE_LOG_FILENAME" ) != null ) {
			cfgDebugTraceLogFilename = getProperty( "DEBUG_TRACE_LOG_FILENAME" );
		}
		if( getProperty( "SELECTOR_RUNLOG_FILENAME" ) != null ) {
			cfgSelectorRunLogFilename = getProperty( "SELECTOR_RUNLOG_FILENAME" );
		}

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		} else {
			return null;
		}
	}
}

// end of RSSRoutingNodeSelectorConfig.java
