/**
 * RSSRoutingNodeConfig
 * RSS oHVXe̐ݒēNX
 */
package org.logical_paradox.rss.router;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.router.algorithm.AllocatingAlgorithm;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public class RSSRoutingNodeConfig extends RSSConfig {
	private String cfgRSSRoutingNodeSelector = "route_selector";
	private String cfgRSSRNodeClientFactory = "";
	private RoutingAlgorithm cfgRoutingAlgorithm;
	private AllocatingAlgorithm cfgAllocatingAlgorithm;
	private int cfgRSSRNodeClientCapacity = 128;
	private String cfgRSSFactoryDefaultURLs = "";
	private int cfgRSSForwardedURLsBetweenFactories = 256;
	private int cfgRSSForwardedURLsFromFactoryToMgr = 128;
	private int cfgRSSForwardedURLsMgrToClient = 32;
	private boolean cfgFactorySwDebugTraceLog = false;
	private boolean cfgFactorySwRunLog = false;
	private String cfgDebugTraceLogFilename = "rss.factory.trace.log";
	private String cfgFactoryRunLogFilename = "rss.factory.run.log";
	private String[] cfgRoutingIPRanges;

	/**
	 * RXgN^
	 */
	public RSSRoutingNodeConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	/**
	 * ANZT
	 */
	public String getRSSRoutingNodeSelector() {
		return cfgRSSRoutingNodeSelector;
	}
	public String getRSSRNodeClientFactory() {
		return cfgRSSRNodeClientFactory;
	}
	public int getRSSRNodeClientCapacity() {
		return cfgRSSRNodeClientCapacity;
	}
	public String getRSSFactoryDefaultURLs() {
		return cfgRSSFactoryDefaultURLs;
	}
	public int getRSSForwardedURLsBetweenFactories() {
		return cfgRSSForwardedURLsBetweenFactories;
	}
	public int getRSSForwardedURLsFromFactoryToMgr() {
		return cfgRSSForwardedURLsFromFactoryToMgr;
	}
	public int getRSSForwardedURLsMgrToClient() {
		return cfgRSSForwardedURLsMgrToClient;
	}
	public boolean getFactorySwDebugTraceLog() {
		return cfgFactorySwDebugTraceLog;
	}
	public boolean getFactorySwRunLog() {
		return cfgFactorySwRunLog;
	}
	public String getDebugTraceLogFilename() {
		return cfgDebugTraceLogFilename;
	}
	public String getFactoryRunLogFilename() {
		return cfgFactoryRunLogFilename;
	}
	public RoutingAlgorithm getRoutingAlgorithm() {
		return cfgRoutingAlgorithm;
	}
	public AllocatingAlgorithm getAllocatingAlgorithm() {
		return cfgAllocatingAlgorithm;
	}
	public String[] getRoutingIPRanges() {
		return cfgRoutingIPRanges;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		if( getProperty( "RSS_ROUTING_NODE_SELECTOR" ) != null ) {
			cfgRSSRoutingNodeSelector = getProperty( "RSS_ROUTING_NODE_SELECTOR" );
		}
		if( (cfgRSSRNodeClientFactory = getProperty( "RSS_RNODE_CLIENT_FACTORY" )) == null ) {
			errmsg += "RSS_RNODE_CLIENT_FACTORYw肳Ă܂\n";
		}
		try {
			cfgRSSRNodeClientCapacity = getPropertyAsInt( "RSS_RNODE_CLIENT_CAPACITY" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "RSS_RNODE_CLIENT_CAPACITYsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgRSSFactoryDefaultURLs = getProperty( "RSS_FACTORY_DEFAULT_URLS" );

		try {
			cfgRSSForwardedURLsBetweenFactories = getPropertyAsInt( "RSS_FORWARDED_URLS_BETWEEN_FACTORIES" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "RSS_FORWARDED_URLS_BETWEEN_FACTORIESsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgRSSForwardedURLsFromFactoryToMgr = getPropertyAsInt( "RSS_FORWARDED_URLS_FROM_FACTORY_TO_MGR" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "RSS_FORWARDED_URLS_FROM_FACTORY_TO_MGRsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgRSSForwardedURLsMgrToClient = getPropertyAsInt( "RSS_FORWARDED_URLS_FROM_MGR_TO_CLIENT" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "RSS_FORWARDED_URLS_FROM_MGR_TO_CLIENTsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgFactorySwDebugTraceLog = getPropertyAsBool( "FACTORY_SW_DEBUG_TRACE_LOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "FACTORY_SW_DEBUG_TRACE_LOGsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgFactorySwRunLog = getPropertyAsBool( "FACTORY_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "FACTORY_SW_RUNLOGsł\n";
		} catch( RSSNullValueException ne ) {}

		if( getProperty( "DEBUG_TRACE_LOG_FILENAME" ) != null ) {
			cfgDebugTraceLogFilename = getProperty( "DEBUG_TRACE_LOG_FILENAME" );
		}
		if( getProperty( "FACTORY_RUNLOG_FILENAME" ) != null ) {
			cfgFactoryRunLogFilename = getProperty( "FACTORY_RUNLOG_FILENAME" );
		}

		try {
			if( getProperty( "ALLOCATING_ALGORITHM" ) != null ) {
				cfgAllocatingAlgorithm = (AllocatingAlgorithm)Class.forName( getProperty( "ALLOCATING_ALGORITHM" ) ).newInstance();
			}
		} catch( Exception allocatingAlgorithmExp ) {
			errmsg += "ALLOCATING_ALGORITHMlCX^Xł܂\n";
		}
		try {
			if( getProperty( "ROUTING_ALGORITHM" ) != null ) {
				cfgRoutingAlgorithm = (RoutingAlgorithm)Class.forName( getProperty( "ROUTING_ALGORITHM" ) ).newInstance();
			}
		} catch( Exception allocatingAlgorithmExp ) {
			errmsg += "ROUTING_ALGORITHMlCX^Xł܂\n";
		}

		String cfgRoutingIPRangesFilename = getProperty( "ROUTING_IP_RANGES_FILENAME" );
		if( cfgRoutingIPRangesFilename == null ) {
			errmsg += "oH͈͒`t@Cw肳Ă܂\n";
		} else {
			ArrayList lines = new ArrayList();
			try {
				BufferedReader br = new BufferedReader( new InputStreamReader( new FileInputStream( cfgRoutingIPRangesFilename ) ) );
				String line = null;
				while( (line = br.readLine()) != null ) {
					lines.add( new String(line.trim()) );
				}
				br.close();

				cfgRoutingIPRanges = (String[])lines.toArray( new String[0] );
			} catch( IOException ioe ) {
				errmsg += "oH͈͒`t@C̓ǂݍ݂Ɏs܂\n";
				cfgRoutingIPRanges = null;
			}
		}

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		}

		return null;
	}
}

// end of RSSRoutingNodeConfig.java
