/*
 * RNodeDSyncMngr
 * oHm[h/RSSWebNavigatorɂxf[^񑗂̃[eBeB
 * ̃NXgƁCbN̍ǗȂǂł
 */
package org.logical_paradox.rss.router;

import java.util.Vector;

import org.logical_paradox.common.net.IPAddressRangeSet;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.dsync.RSSSyncDaemon;
import org.logical_paradox.rss.dsync.RSSSyncInterface;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.URLPool;

public class RNodeDSyncMngr extends RSSSyncDaemon {
	private final RestrictedSiteLockMgr lockMgr;
	private final URLPool pool;

	public RNodeDSyncMngr( RSSSyncConfig daemonConfig, RSSSyncInterface dsi, long maxlocks, URLPool p, IPAddressRangeSet rs ) throws Exception {
		super( daemonConfig, dsi );
		lockMgr = new RestrictedSiteLockMgr( maxlocks, rs );
		pool = p;
	}

	/**
	 * bNǉ
	 * bNǉ邱ƂłꍇtrueCsꍇfalseԂ
	 */
	public boolean lock( SiteLock l ) throws SyncQueueException {
		boolean rc = lockMgr.lock( l );
		if( rc == true ) {
			// bNǉł̂ŁC
			add( new SyncCommand( l, SyncCommand.COMMAND_LOCK, null, null ) );
		}
		return rc;
	}

	/**
	 * w肳ꂽbN擾
	 * w肳Tm[hIDŎ擾łȂꍇnull
	 */
	public SiteLock findLock( String dn, String rid ) {
		return lockMgr.findLock( dn, rid );
	}

	/**
	 * TCgbÑS~
	 * S~̃XgzŕԂ
	 */
	public SiteLock[] gc() {
		SiteLock[] removedObjLocal = lockMgr.gc();			// [JGC
		Vector removedObjRemote = new Vector();				// L[ɍڂꂽAbN

		// ؂ō폜ꂽTbNUNLOCKƂđ̃m[hւ]
		try {
			for( int i = 0; i < removedObjLocal.length; i++ ) {
				unlock( removedObjLocal[i] );
				removedObjRemote.addElement( removedObjLocal[i] );
			}
		} catch( SyncQueueException se ) {
			// L[ςɂȂĂ邭̂ŁCI
			// c͎ɉ񂵂Ă݂
		}

		return (SiteLock[])removedObjRemote.toArray( new SiteLock[1] );
	}

	/**
	 * wID̒Tm[hۗLĂ郍bN̐Ԃ
	 */
	public int numOfMyLocks( String robotId ) {
		return lockMgr.numOfMyLocks( robotId );
	}

	/**
	 * URLv[Ԃ
	 */
	public URLPool getPool() {
		return pool;
	}

	/**
	 * bN
	 */
	public void unlock( SiteLock l ) throws SyncQueueException {
		lockMgr.unlock( l );
		add( new SyncCommand( l, SyncCommand.COMMAND_UNLOCK, null, null ) );
	}

	/**
	 * URLǉ
	 */
	public void poolURL( String url ) throws SyncQueueException {
		add( new SyncCommand( url, SyncCommand.COMMAND_FORWARD_URL, null, null ) );
	}

	/**
	 * URL폜
	 */
	public void dropURL( String url ) throws SyncQueueException {
		add( new SyncCommand( url, SyncCommand.COMMAND_UNFORWARD_URL, null, null ) );
	}

	/**
	 * xf[̏I
	 *̃\bhĂяoƁCxf[̃obt@tbVȂSɏI
	 */
	public void done() {
		interrupt();
	}
}

// end of RNodeDSyncMngr.java
