/**
 * RNodeClientFactoryImpl()
 * oHm[hNCAg쐬t@Ng
 * KvɉĐVCX^XǉDKvȂꍇ́Ĉ̂Ԃ
 */
package org.logical_paradox.rss.router;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModuleIF;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueue;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.logging.RSSLogWriter;
import org.logical_paradox.rss.logging.RSSRoutingNodeLogWriter;
import org.logical_paradox.rss.router.algorithm.AllocatingAlgorithm;
import org.logical_paradox.rss.router.algorithm.AllocationException;

public class RNodeClientFactoryImpl extends UnicastRemoteObject implements RNodeClientFactory, RSSSubModuleIF {
	public static final String RSS_ROUTING_NODE_CONFIG = "conf/rssroutingfactory.conf";

	private Hashtable searchNodes = null;						// ̃NCAgt@NgǗĂTm[h
	private RSSRoutingNodeSelector nodeSelector = null;			// Iq
	private String factoryServiceName = null;					// ̃T[rX̖O
	private RSSRoutingNodeConfig config = null;					// ̃t@Ng̃RtBO
	private URLPool unTracedURLs = null;						// URL
	private int rnodeClientCapacity = 32;						// Ǌ\ȃNCAg̐
	private SyncQueue syncQueue = new SyncQueue();				// TbNp̃L[
	private SyncQueue rejectedCommandQueue = new SyncQueue();	// ۂĂbNvۊǂL[
	private AllocatingAlgorithm allocater = null;				// zASY

	/**
	 * ftHgRXgN^
	 */
	public RNodeClientFactoryImpl() throws RemoteException {
	}

	/**
	 * 
	 */
	public void init( String fn, String selectorServiceUrl ) throws RemoteException {
		if( selectorServiceUrl == null || selectorServiceUrl.trim().length() == 0 ) {
			throw new RemoteException( "selector service name is empty" );
		}

		factoryServiceName = fn;
		unTracedURLs = new URLPool();
		searchNodes = new Hashtable();

		try {
			// oHm[hIqɃT[rXC
			RSSRoutingNodeLogWriter.write( "oHm[hIT[rX'" + selectorServiceUrl + "'ɃT[rXCĂ܂" );

			nodeSelector = (RSSRoutingNodeSelector)Naming.lookup( selectorServiceUrl );
			nodeSelector.bindRoutingNode( factoryServiceName, this );

			RSSRoutingNodeLogWriter.write( "T[rXCɐ܂" );
		} catch( Exception e ) {
			RSSRoutingNodeLogWriter.write( "T[rXCɎs܂" );
			throw (RemoteException)e;
		}
	}

	/**
	 * RXgN^
	 */
	public RNodeClientFactoryImpl( String fn, String selectorServiceUrl ) throws RemoteException {
		init( fn, selectorServiceUrl );
	}

	/**
	 * ̃t@Ng̖OԂ
	 */
	public String getNodeId() throws RemoteException {
		return factoryServiceName;
	}

	/**
	 * Tm[hoCh
	 */
	public RoutingNodeClient bindSearchNode() throws RemoteException {
		RSSRoutingNodeLogWriter.write( "Tm[hoChĂ܂" );

		// Tm[hoCh鏈
		RoutingNodeClient client = attachSearchNode();

		try {
			RSSRoutingNodeLogWriter.write( "Tm[hCO'" + client.getNodeId() + "'Ƃēo^܂" );
		} catch( Exception e ) {
			throw new RemoteException( e.getMessage() );
		}
		return client;
	}

	/**
	 * Tm[h؂藣
	 */
	public void unbindSearchNode( String robotId ) throws RemoteException {
		RSSRoutingNodeLogWriter.write( "Tm[h'" + robotId + "'؂藣Ă܂" );

		boolean exitf = true;
		if( detachSearchNode( robotId ) ) {
			exitf = false;
		}

		if( exitf ) {
			// NǗĂȂTm[h
			RSSRoutingNodeLogWriter.write( "ǗĂȂTm[h'" + robotId + "'؂藣Ƃ܂" );
			throw new RemoteException( "no routing manager manages the robot '" + robotId + "'." );
		}

		RSSRoutingNodeLogWriter.write( "Tm[h'" + robotId + "'؂藣܂" );
	}

	/**
	 * Tm[hoCh
	 */
	public RoutingNodeClient attachSearchNode() throws RemoteException {
		RoutingNodeClientImpl rn = new RoutingNodeClientImpl( this );
		searchNodes.put( rn.getNodeId(), rn );

		// zASYɃm[hǉ
		allocater.addChildNode( rn.getNodeId() );

		return rn;
	}

	/**
	 * Tm[h؂藣
	 */
	public boolean detachSearchNode( String robotId ) {
		boolean rc = false;
		synchronized( searchNodes ) {
			RoutingNodeClient rnc = (RoutingNodeClient)searchNodes.get( robotId );
			if( rnc == null || searchNodes.remove( robotId ) == null ) {
				// Tm[h̐؂藣Ɏsꍇ
				// ʏ픭ȂCɐ؂藣ĂꍇȂ
				rc = false;
			} else {
				// zASYm[h폜
				allocater.removeChildNode( robotId );
				rc = true;
			}
		}

		return rc;
	}

	/**
	 * URLt@Ng̃v[폜
	 */
	public void removeUnTracedURL( String url ) throws RemoteException {
		try {
			synchronized( unTracedURLs ) {
				unTracedURLs.remove( url );
			}
		} catch( MalformedURLException ue ) {
			throw new RemoteException( ue.getMessage() );
		}
	}

	/**
	 * t@NgɐVURLǉ
	 */
	public void addUnTracedURL( String url ) throws RemoteException {
		try {
			unTracedURLs.add( url );
		} catch( MalformedURLException ue ) {
			throw new RemoteException( ue.getMessage() );
		}
	}

	/**
	 * Kȉʃm[hɑ΂āCURL蓖Ă
	 */
	public void allocateURL() {
		try {
			synchronized( unTracedURLs ) {
				String[] domains = unTracedURLs.domains();
				for( int i = 0; i < domains.length; i++ ) {
					String domain = domains[i];
					String[] urls = unTracedURLs.urls( domain );

					for( int j = 0; j < urls.length; j++ ) {
						try {
							String destNodeId = allocater.allocate( urls[j] );
							rejectedCommandQueue.add( new SyncCommand( urls[j], SyncCommand.COMMAND_FORWARD_URL, getNodeId(), destNodeId ) );
							unTracedURLs.remove( urls[j] );
						} catch( RemoteException re ) {
							re.printStackTrace();
						} catch( AllocationException ae ) {
							ae.printStackTrace();
						} catch( SyncQueueException se ) {
							// ̂Ăꂽ
						} catch( MalformedURLException ue ) {
							// ̂Ăꂽ
						}
					}
				}
			}
		} catch( NoSuchElementException nse ) {
			// XgɂȂꍇDȂ
		}
	}

	/*
	 * T̋ĂIPAhX͈͂̈ꗗԂ
	 */
	public String[] getAllowedRoutingIPRanges() throws RemoteException {
		return config.getRoutingIPRanges();
	}

	/**
	 * Tm[ḧꗗԂ
	 */
	public String[] getClientNames() throws RemoteException {
		Vector tmp = new Vector();
		synchronized( searchNodes ) {
			Enumeration e = searchNodes.keys();
			while( e.hasMoreElements() ) {
				tmp.addElement( e.nextElement() );
			}
		}

		if( tmp.size() == 0 ) {
			return null;
		} else {
			return (String[])tmp.toArray( new String[1] );
		}
	}

	/**
	 * w肳ꂽm[hɈĂTbN̍Ԃ
	 */
	public SyncCommand[] getModifiedSyncData( String rk ) throws RemoteException {
		allocateURL();				// URLv[ɎcĂ̂CR}h֕ϊĂ݂
		SyncCommand[] o = rejectedCommandQueue.get( rk );
		rejectedCommandQueue.clear( rk );
		return o;
	}

	/**
	 * TbN̍ۑ
	 */
	public void sync( SyncCommand[] locks ) throws Exception {
		if( locks == null || locks.length == 0 ) {
			return;
		}
		RSSDebugLogWriter.write( locks.length + "̓f[^M܂" );

		Vector receivedCommands = new Vector( Arrays.asList( locks ) );
		SyncCommand[] rejectedCommands = syncQueue.add( locks );
		receivedCommands.removeAll( Arrays.asList( rejectedCommands ) );	// MR}h - ۂꂽ = 󗝂ꂽ

		for( int i = 0; i < receivedCommands.size(); i++ ) {
			SyncCommand command = (SyncCommand)receivedCommands.elementAt(i);
			if( command.getType() == SyncCommand.COMMAND_FORWARD_URL ) {
				// URLMꍇCURLv[Ɋi[
				unTracedURLs.add( (String)command.getObject() );
			}
		}

		// out queueɋۂꂽR}ho^
		rejectedCommandQueue.add( rejectedCommands );
	}

	public static void main( String[] args ) {
		try {
			RNodeClientFactoryImpl factory = new RNodeClientFactoryImpl();
			factory.startModule();
		} catch( Exception e ) {
			System.err.println( e.getMessage() );
			e.printStackTrace();
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			RSSRoutingNodeConfig conf = new RSSRoutingNodeConfig( RSS_ROUTING_NODE_CONFIG );

			// OC^[̍\z
			RSSRoutingNodeLogWriter.setLogWriter( new RSSLogWriter( new FileOutputStream( "logs" + File.separator + conf.getFactoryRunLogFilename(), true ) ) );
			RSSRoutingNodeLogWriter.setLoggingMode( conf.getFactorySwRunLog() );
			RSSRoutingNodeLogWriter.write( "OC^[܂" );

			// t@Ng̍\zƃT[rXC
			String RNodeClientFactoryName = conf.getRSSRNodeClientFactory();

			init( RNodeClientFactoryName, conf.getRSSRoutingNodeSelector() );
			rnodeClientCapacity = conf.getRSSRNodeClientCapacity();

			// zASY̐ݒ
			allocater = conf.getAllocatingAlgorithm();
			allocater.setRoutingAlgorithm( conf.getRoutingAlgorithm() );

			// configɐݒ肳Ă鏉URLĈ̂Ƃēo^
			String defaultURLsLine = conf.getRSSFactoryDefaultURLs();
			if( defaultURLsLine != null ) {
				String[] defaultURLs = defaultURLsLine.split( "," );
				for( int i = 0; i < defaultURLs.length; i++ ) {
					addUnTracedURL( defaultURLs[i] );
				}
			}

			// RMIWXgɃt@NgT[rXo^
			Naming.rebind( RNodeClientFactoryName, this );
			config = conf;

			System.err.println( "RNodeClientFactory '" + RNodeClientFactoryName + "' is started" );
			RSSRoutingNodeLogWriter.write( "oHm[hNCAgt@NgT[rX'" + RNodeClientFactoryName + "'Jn܂" );
		} catch( Exception e ) {
			throw new ModuleException( e );
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}
}

// end of RNodeClientFactoryImpl.java
